/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.dispatch;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.event.Event;
import reactor.event.dispatch.BaseDispatcher;
import reactor.event.dispatch.BaseLifecycleDispatcher;
import reactor.support.NamedDaemonThreadFactory;

public class RingBufferDispatcher
extends BaseLifecycleDispatcher {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final ExecutorService executor;
    private final Disruptor<RingBufferTask<?>> disruptor;
    private final RingBuffer<RingBufferTask<?>> ringBuffer;

    public RingBufferDispatcher(String name) {
        this(name, 1024, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
    }

    public RingBufferDispatcher(String name, int bufferSize, ProducerType producerType, WaitStrategy waitStrategy) {
        this.executor = Executors.newSingleThreadExecutor(new NamedDaemonThreadFactory(name + "-ringbuffer"));
        this.disruptor = new Disruptor(new EventFactory<RingBufferTask<?>>(){

            public RingBufferTask<?> newInstance() {
                return new RingBufferTask();
            }
        }, bufferSize, (Executor)this.executor, producerType, waitStrategy);
        this.disruptor.handleExceptionsWith(new ExceptionHandler(){

            public void handleEventException(Throwable ex, long sequence, Object event) {
            }

            public void handleOnStartException(Throwable ex) {
                Logger log = LoggerFactory.getLogger(RingBufferDispatcher.class);
                if (log.isErrorEnabled()) {
                    log.error(ex.getMessage(), ex);
                }
            }

            public void handleOnShutdownException(Throwable ex) {
                Logger log = LoggerFactory.getLogger(RingBufferDispatcher.class);
                if (log.isErrorEnabled()) {
                    log.error(ex.getMessage(), ex);
                }
            }
        });
        this.disruptor.handleEventsWith(new EventHandler[]{new RingBufferTaskHandler()});
        this.ringBuffer = this.disruptor.start();
    }

    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        this.shutdown();
        try {
            return this.executor.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void shutdown() {
        this.disruptor.shutdown();
        this.executor.shutdown();
        super.shutdown();
    }

    @Override
    public void halt() {
        this.executor.shutdownNow();
        this.disruptor.halt();
        super.halt();
    }

    @Override
    protected <E extends Event<?>> BaseDispatcher.Task<E> createTask() {
        long l = this.ringBuffer.next();
        RingBufferTask t = (RingBufferTask)this.ringBuffer.get(l);
        t.setSequenceId(l);
        return t;
    }

    private class RingBufferTaskHandler
    implements EventHandler<RingBufferTask<?>> {
        private RingBufferTaskHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(RingBufferTask<?> t, long sequence, boolean endOfBatch) throws Exception {
            try {
                t.execute();
            }
            finally {
                t.reset();
            }
        }
    }

    private class RingBufferTask<E extends Event<?>>
    extends BaseDispatcher.Task<E> {
        private long sequenceId;

        private RingBufferTask() {
            super(RingBufferDispatcher.this);
        }

        private RingBufferTask<E> setSequenceId(long sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        @Override
        public void submit() {
            RingBufferDispatcher.this.ringBuffer.publish(this.sequenceId);
        }
    }
}

