/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.routing;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import reactor.convert.Converter;
import reactor.event.Event;
import reactor.event.routing.ConsumerInvoker;
import reactor.function.Consumer;

public final class ArgumentConvertingConsumerInvoker
implements ConsumerInvoker {
    private static final ReentrantReadWriteLock CACHE_LOCK = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock CACHE_READ_LOCK = CACHE_LOCK.readLock();
    private static final ReentrantReadWriteLock.WriteLock CACHE_WRITE_LOCK = CACHE_LOCK.writeLock();
    private static final Map<String, Class<?>> ARG_TYPE_CACHE = new WeakHashMap();
    private final Converter converter;

    public ArgumentConvertingConsumerInvoker(Converter converter) {
        this.converter = converter;
    }

    @Override
    public <T> T invoke(Consumer<?> consumer, Class<? extends T> returnType, Object ... possibleArgs) throws Exception {
        try {
            consumer.accept(possibleArgs.length > 0 ? possibleArgs[0] : null);
        }
        catch (ClassCastException e) {
            Class<T> argType = ArgumentConvertingConsumerInvoker.resolveArgType(consumer);
            if (argType == Object.class) {
                throw e;
            }
            for (int i = 1; i < possibleArgs.length; ++i) {
                Object o = possibleArgs[i];
                if (null == o) continue;
                if (argType.isInstance(o)) {
                    return this.invoke(consumer, returnType, o);
                }
                if (null != this.converter && this.converter.canConvert(o.getClass(), argType)) {
                    return this.invoke(consumer, returnType, this.converter.convert(o, argType));
                }
                if (!Event.class.isInstance(o) || null == ((Event)o).getData() || !argType.isInstance(((Event)o).getData())) continue;
                return this.invoke(consumer, returnType, ((Event)o).getData());
            }
            if (possibleArgs.length == 1 && Event.class.isInstance(possibleArgs[0])) {
                return this.invoke(consumer, returnType, ((Event)possibleArgs[0]).getData());
            }
            throw e;
        }
        if (Void.TYPE == returnType) {
            return null;
        }
        if (consumer instanceof Callable) {
            Object o = ((Callable)((Object)consumer)).call();
            if (null == o) {
                return null;
            }
            if (returnType.isAssignableFrom(o.getClass())) {
                return (T)o;
            }
            if (null != this.converter && this.converter.canConvert(o.getClass(), returnType)) {
                return this.converter.convert(o, returnType);
            }
            throw new IllegalArgumentException("Cannot convert object of type " + o.getClass().getName() + " to " + returnType.getName());
        }
        return null;
    }

    @Override
    public boolean supports(Consumer<?> consumer) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Class<? extends T> resolveArgType(Consumer<?> consumer) {
        Class<?> clazz;
        CACHE_READ_LOCK.lock();
        try {
            clazz = ARG_TYPE_CACHE.get(consumer.getClass().getName());
            if (null != clazz) {
                Class<?> clazz2 = clazz;
                return clazz2;
            }
        }
        finally {
            CACHE_READ_LOCK.unlock();
        }
        if (Event.class.isInstance(consumer) && null != ((Event)((Object)consumer)).getData()) {
            return ((Event)((Object)consumer)).getData().getClass();
        }
        for (Type t : consumer.getClass().getGenericInterfaces()) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type t1 = pt.getActualTypeArguments()[0];
                if (t1 instanceof ParameterizedType) {
                    clazz = (Class<?>)((ParameterizedType)t1).getRawType();
                } else if (t1 instanceof Class) {
                    clazz = (Class)t1;
                }
            }
            if (null == clazz) continue;
            CACHE_WRITE_LOCK.lock();
            try {
                ARG_TYPE_CACHE.put(consumer.getClass().getName(), clazz);
                break;
            }
            finally {
                CACHE_WRITE_LOCK.unlock();
            }
        }
        if (null == clazz) {
            for (Method m : consumer.getClass().getDeclaredMethods()) {
                if (!"accept".equals(m.getName()) || m.getParameterTypes().length != 1) continue;
                clazz = m.getParameterTypes()[0];
                CACHE_WRITE_LOCK.lock();
                try {
                    ARG_TYPE_CACHE.put(consumer.getClass().getName(), clazz);
                }
                finally {
                    CACHE_WRITE_LOCK.unlock();
                }
                return clazz;
            }
        }
        return clazz;
    }
}

