/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.selector;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import reactor.event.selector.HeaderResolver;
import reactor.event.selector.ObjectSelector;
import reactor.event.selector.Selector;

public class RegexSelector
extends ObjectSelector<Pattern> {
    private final HeaderResolver headerResolver = new HeaderResolver(){

        @Override
        @Nullable
        public Map<String, String> resolve(Object key) {
            Matcher m = ((Pattern)RegexSelector.this.getObject()).matcher(key.toString());
            if (!m.matches()) {
                return null;
            }
            int groups = m.groupCount();
            HashMap<String, String> headers = new HashMap<String, String>();
            for (int i = 1; i <= groups; ++i) {
                String name = "group" + i;
                String value = m.group(i);
                headers.put(name, value);
            }
            return headers;
        }
    };

    public RegexSelector(String pattern) {
        super(Pattern.compile(pattern));
    }

    public static Selector regexSelector(String regex) {
        return new RegexSelector(regex);
    }

    @Override
    public boolean matches(Object key) {
        return key instanceof String && ((Pattern)this.getObject()).matcher((String)key).matches();
    }

    @Override
    public HeaderResolver getHeaderResolver() {
        return this.headerResolver;
    }
}

