/*
 * Decompiled with CFR 0.152.
 */
package reactor.function.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import reactor.function.Consumer;

public class Boundary {
    private final List<CountDownLatch> latches = new ArrayList<CountDownLatch>();

    public <T> Consumer<T> bind(Consumer<T> consumer) {
        return this.bind(consumer, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Consumer<T> bind(final Consumer<T> consumer, int expected) {
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            final CountDownLatch latch = new CountDownLatch(expected);
            this.latches.add(latch);
            return new Consumer<T>(){

                @Override
                public void accept(T t) {
                    consumer.accept(t);
                    latch.countDown();
                }
            };
        }
    }

    public boolean await() {
        return this.await(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit timeUnit) {
        if (this.latches.isEmpty()) {
            return true;
        }
        long start = System.currentTimeMillis();
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            try {
                long elapsed = 0L;
                for (CountDownLatch latch : this.latches) {
                    boolean b = latch.await(timeoutMillis - elapsed, TimeUnit.MILLISECONDS);
                    elapsed = System.currentTimeMillis() - start;
                    if (b && elapsed < timeoutMillis) continue;
                    return false;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return System.currentTimeMillis() - start < timeoutMillis;
    }
}

