/*
 * Decompiled with CFR 0.152.
 */
package reactor.function.support;

import javax.annotation.Nonnull;
import reactor.function.Consumer;
import reactor.function.Predicate;
import reactor.function.support.CancelConsumerException;
import reactor.util.Assert;

public abstract class CancellableConsumer<T>
implements Consumer<T> {
    private final Predicate<T> predicate;

    public CancellableConsumer(@Nonnull Predicate<T> predicate) {
        Assert.notNull(predicate, "Predicate cannot be null.");
        this.predicate = predicate;
    }

    @Override
    public void accept(T obj) {
        if (!this.predicate.test(obj)) {
            throw new CancelConsumerException(obj + " failed Predicate test " + this.predicate);
        }
        this.doAccept(obj);
    }

    protected abstract void doAccept(T var1);
}

