/*
 * Decompiled with CFR 0.152.
 */
package reactor.function.support;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import reactor.function.Consumer;
import reactor.function.batch.BatchConsumer;
import reactor.util.Assert;

public class DelegatingConsumer<T>
implements BatchConsumer<T>,
Iterable<Consumer<T>> {
    private final Object delegateMonitor = new Object(){};
    private final List<WeakReference<Consumer<T>>> delegates = new ArrayList<WeakReference<Consumer<T>>>();
    private volatile int delegateSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelegatingConsumer<T> add(Consumer<T> consumer) {
        Assert.notNull(consumer, "Consumer cannot be null.");
        Object object = this.delegateMonitor;
        synchronized (object) {
            this.delegates.add(new WeakReference<Consumer<T>>(consumer));
            this.delegateSize = this.delegates.size();
        }
        return this;
    }

    public DelegatingConsumer<T> add(Collection<Consumer<T>> consumers) {
        if (null == consumers || consumers.isEmpty()) {
            return this;
        }
        for (Consumer<T> c : consumers) {
            this.add(c);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelegatingConsumer<T> remove(Consumer<T> consumer) {
        Object object = this.delegateMonitor;
        synchronized (object) {
            for (WeakReference<Consumer<T>> ref : this.delegates) {
                if (ref.get() != consumer) continue;
                ref.clear();
                break;
            }
        }
        return this;
    }

    public DelegatingConsumer<T> remove(Collection<Consumer<T>> consumers) {
        if (null == consumers || consumers.isEmpty()) {
            return this;
        }
        for (Consumer<T> c : consumers) {
            this.remove(c);
        }
        this.prune();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelegatingConsumer<T> prune() {
        Object object = this.delegateMonitor;
        synchronized (object) {
            ArrayList<WeakReference<Consumer<T>>> delegatesToRemove = new ArrayList<WeakReference<Consumer<T>>>();
            for (WeakReference<Consumer<T>> ref : this.delegates) {
                if (null != ref.get()) continue;
                delegatesToRemove.add(ref);
            }
            this.delegates.removeAll(delegatesToRemove);
            this.delegateSize = this.delegates.size();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelegatingConsumer<T> clear() {
        Object object = this.delegateMonitor;
        synchronized (object) {
            this.delegates.clear();
            this.delegateSize = this.delegates.size();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T t) {
        Object object = this.delegateMonitor;
        synchronized (object) {
            int size = this.delegateSize;
            for (int i = 0; i < size; ++i) {
                Consumer c;
                WeakReference<Consumer<T>> ref = this.delegates.get(i);
                if (null == ref || null == (c = (Consumer)ref.get())) continue;
                c.accept(t);
            }
        }
    }

    @Override
    @Nonnull
    public Iterator<Consumer<T>> iterator() {
        return new Iterator<Consumer<T>>(){
            final Iterator<WeakReference<Consumer<T>>> delegatesIter;
            {
                this.delegatesIter = DelegatingConsumer.this.delegates.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegatesIter.hasNext();
            }

            @Override
            public Consumer<T> next() {
                return (Consumer)this.delegatesIter.next().get();
            }

            @Override
            public void remove() {
                this.delegatesIter.remove();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.delegateMonitor;
        synchronized (object) {
            int size = this.delegateSize;
            for (int i = 0; i < size; ++i) {
                Consumer c;
                WeakReference<Consumer<T>> ref = this.delegates.get(i);
                if (null == ref || null == (c = (Consumer)ref.get()) || !(c instanceof BatchConsumer)) continue;
                ((BatchConsumer)c).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        Object object = this.delegateMonitor;
        synchronized (object) {
            int size = this.delegateSize;
            for (int i = 0; i < size; ++i) {
                Consumer c;
                WeakReference<Consumer<T>> ref = this.delegates.get(i);
                if (null == ref || null == (c = (Consumer)ref.get()) || !(c instanceof BatchConsumer)) continue;
                ((BatchConsumer)c).end();
            }
        }
    }
}

