/*
 * Decompiled with CFR 0.152.
 */
package reactor.queue.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import reactor.function.Function;
import reactor.io.Buffer;
import reactor.queue.encoding.Codec;

public class JavaSerializationCodec<T>
implements Codec<T> {
    private final Decoder decoder = new Decoder();
    private final Encoder encoder = new Encoder();

    @Override
    public Function<Buffer, T> decoder() {
        return this.decoder;
    }

    @Override
    public Function<T, Buffer> encoder() {
        return this.encoder;
    }

    private class Encoder
    implements Function<T, Buffer> {
        private Encoder() {
        }

        @Override
        public Buffer apply(T t) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(t);
                oos.flush();
                oos.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            return Buffer.wrap(baos.toByteArray());
        }
    }

    private class Decoder
    implements Function<Buffer, T> {
        private Decoder() {
        }

        @Override
        public T apply(Buffer buff) {
            if (buff.remaining() <= 0) {
                return null;
            }
            try {
                return new ObjectInputStream(new ByteArrayInputStream(buff.asBytes())).readObject();
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }
}

