/*
 * Decompiled with CFR 0.152.
 */
package reactor.util;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantLock;

public abstract class UUIDUtils {
    private static boolean IS_THREADLOCALRANDOM_AVAILABLE = false;
    private static Random random;
    private static final long leastSigBits;
    private static final ReentrantLock lock;
    private static long lastTime;

    private UUIDUtils() {
    }

    public static UUID random() {
        byte[] randomBytes = new byte[16];
        if (IS_THREADLOCALRANDOM_AVAILABLE) {
            ThreadLocalRandom.current().nextBytes(randomBytes);
        } else {
            random.nextBytes(randomBytes);
        }
        long mostSigBits = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        long leastSigBits = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return new UUID(mostSigBits, leastSigBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID create() {
        long timeMillis = System.currentTimeMillis() * 10000L + 122192928000000000L;
        lock.lock();
        try {
            if (timeMillis > lastTime) {
                lastTime = timeMillis;
            } else {
                timeMillis = ++lastTime;
            }
        }
        finally {
            lock.unlock();
        }
        long mostSigBits = timeMillis << 32;
        mostSigBits |= (timeMillis & 0xFFFF00000000L) >> 16;
        return new UUID(mostSigBits |= 0x1000L | timeMillis >> 48 & 0xFFFL, leastSigBits);
    }

    static {
        lock = new ReentrantLock();
        try {
            IS_THREADLOCALRANDOM_AVAILABLE = null != UUIDUtils.class.getClassLoader().loadClass("java.util.concurrent.ThreadLocalRandom");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        byte[] seed = new SecureRandom().generateSeed(8);
        leastSigBits = new BigInteger(seed).longValue();
        if (!IS_THREADLOCALRANDOM_AVAILABLE) {
            random = new Random(leastSigBits);
        }
    }
}

