/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.factory.dynamic;

import org.springframework.beans.factory.FactoryBean;
import reactor.core.Environment;
import reactor.core.dynamic.DynamicReactor;
import reactor.core.dynamic.DynamicReactorFactory;

public class DynamicReactorFactoryBean<T extends DynamicReactor>
implements FactoryBean<T> {
    private final boolean singleton;
    private final Class<T> type;
    private final DynamicReactorFactory<T> reactorFactory;

    public DynamicReactorFactoryBean(Environment env, Class<T> type) {
        this.singleton = false;
        this.type = type;
        this.reactorFactory = new DynamicReactorFactory(env, type);
    }

    public DynamicReactorFactoryBean(Environment env, Class<T> type, boolean singleton) {
        this.singleton = singleton;
        this.type = type;
        this.reactorFactory = new DynamicReactorFactory(env, type);
    }

    public T getObject() throws Exception {
        return (T)this.reactorFactory.create();
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return this.singleton;
    }
}

