/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Map;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.FactoryBean;

public class BindingFactoryBean
implements FactoryBean<Binding> {
    private Map<String, Object> arguments;
    private String routingKey = "";
    private String exchange;
    private Queue destinationQueue;
    private Exchange destinationExchange;
    private Boolean shouldDeclare;
    private Boolean ignoreDeclarationExceptions;
    private AmqpAdmin[] adminsThatShouldDeclare;

    public void setArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setDestinationQueue(Queue destinationQueue) {
        this.destinationQueue = destinationQueue;
    }

    public void setDestinationExchange(Exchange destinationExchange) {
        this.destinationExchange = destinationExchange;
    }

    public void setShouldDeclare(boolean shouldDeclare) {
        this.shouldDeclare = shouldDeclare;
    }

    public void setIgnoreDeclarationExceptions(Boolean ignoreDeclarationExceptions) {
        this.ignoreDeclarationExceptions = ignoreDeclarationExceptions;
    }

    public void setAdminsThatShouldDeclare(AmqpAdmin ... adminsThatShouldDeclare) {
        this.adminsThatShouldDeclare = adminsThatShouldDeclare;
    }

    public Binding getObject() {
        Binding.DestinationType destinationType;
        String destination;
        if (this.destinationQueue != null) {
            destination = this.destinationQueue.getName();
            destinationType = Binding.DestinationType.QUEUE;
        } else {
            destination = this.destinationExchange.getName();
            destinationType = Binding.DestinationType.EXCHANGE;
        }
        Binding binding = new Binding(destination, destinationType, this.exchange, this.routingKey, this.arguments);
        if (this.shouldDeclare != null) {
            binding.setShouldDeclare(this.shouldDeclare.booleanValue());
        }
        if (this.ignoreDeclarationExceptions != null) {
            binding.setIgnoreDeclarationExceptions(this.ignoreDeclarationExceptions.booleanValue());
        }
        if (this.adminsThatShouldDeclare != null) {
            binding.setAdminsThatShouldDeclare((Object[])this.adminsThatShouldDeclare);
        }
        return binding;
    }

    public Class<?> getObjectType() {
        return Binding.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

