/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;

class FeignCircuitBreakerInvocationHandler
implements InvocationHandler {
    private final CircuitBreakerFactory factory;
    private final Target<?> target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;
    private final FallbackFactory<?> nullableFallbackFactory;
    private final Map<Method, Method> fallbackMethodMap;

    FeignCircuitBreakerInvocationHandler(CircuitBreakerFactory factory, Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch, FallbackFactory<?> nullableFallbackFactory) {
        this.factory = factory;
        this.target = (Target)Util.checkNotNull(target, (String)"target", (Object[])new Object[0]);
        this.dispatch = (Map)Util.checkNotNull(dispatch, (String)"dispatch", (Object[])new Object[0]);
        this.fallbackMethodMap = FeignCircuitBreakerInvocationHandler.toFallbackMethod(dispatch);
        this.nullableFallbackFactory = nullableFallbackFactory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("equals".equals(method.getName())) {
            try {
                InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                return this.equals(otherHandler);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        String circuitName = Feign.configKey((Class)this.target.type(), (Method)method);
        CircuitBreaker circuitBreaker = this.factory.create(circuitName);
        Supplier<Object> supplier = this.asSupplier(method, args);
        if (this.nullableFallbackFactory != null) {
            Function<Throwable, Object> fallbackFunction = throwable -> {
                Object fallback = this.nullableFallbackFactory.create((Throwable)throwable);
                try {
                    return this.fallbackMethodMap.get(method).invoke(fallback, args);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            };
            return circuitBreaker.run(supplier, fallbackFunction);
        }
        return circuitBreaker.run(supplier);
    }

    private Supplier<Object> asSupplier(Method method, Object[] args) {
        return () -> {
            try {
                return this.dispatch.get(method).invoke(args);
            }
            catch (RuntimeException throwable) {
                throw throwable;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        };
    }

    static Map<Method, Method> toFallbackMethod(Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        LinkedHashMap<Method, Method> result = new LinkedHashMap<Method, Method>();
        for (Method method : dispatch.keySet()) {
            method.setAccessible(true);
            result.put(method, method);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FeignCircuitBreakerInvocationHandler) {
            FeignCircuitBreakerInvocationHandler other = (FeignCircuitBreakerInvocationHandler)obj;
            return this.target.equals(other.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }
}

