/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ExpressionEvaluatingCorrelationStrategy
implements CorrelationStrategy,
BeanFactoryAware {
    private static final ExpressionParser expressionParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private final ExpressionEvaluatingMessageProcessor<Object> processor;

    public ExpressionEvaluatingCorrelationStrategy(String expressionString) {
        Assert.hasText((String)expressionString, (String)"expressionString must not be empty");
        Expression expression = expressionParser.parseExpression(expressionString);
        this.processor = new ExpressionEvaluatingMessageProcessor<Object>(expression, Object.class);
    }

    public ExpressionEvaluatingCorrelationStrategy(Expression expression) {
        this.processor = new ExpressionEvaluatingMessageProcessor<Object>(expression, Object.class);
    }

    @Override
    public Object getCorrelationKey(Message<?> message) {
        return this.processor.processMessage(message);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory != null) {
            this.processor.setBeanFactory(beanFactory);
        }
    }
}

