/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.core.AttributeAccessor;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageUtils;
import org.springframework.integration.support.management.TrackableComponent;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class MessageProducerSupport
extends AbstractEndpoint
implements MessageProducer,
TrackableComponent,
SmartInitializingSingleton {
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private ErrorMessageStrategy errorMessageStrategy = new DefaultErrorMessageStrategy();
    private MessageChannel outputChannel;
    private String outputChannelName;
    private MessageChannel errorChannel;
    private String errorChannelName;
    private boolean shouldTrack = false;

    protected MessageProducerSupport() {
        this.setPhase(0x3FFFFFFF);
    }

    @Override
    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    @Override
    public void setOutputChannelName(String outputChannelName) {
        Assert.hasText((String)outputChannelName, (String)"'outputChannelName' must not be null or empty");
        this.outputChannelName = outputChannelName;
    }

    @Override
    public MessageChannel getOutputChannel() {
        String channelName = this.outputChannelName;
        if (channelName != null) {
            this.outputChannel = (MessageChannel)this.getChannelResolver().resolveDestination(channelName);
            this.outputChannelName = null;
        }
        return this.outputChannel;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setErrorChannelName(String errorChannelName) {
        Assert.hasText((String)errorChannelName, (String)"'errorChannelName' must not be empty");
        this.errorChannelName = errorChannelName;
    }

    @Nullable
    public MessageChannel getErrorChannel() {
        String channelName = this.errorChannelName;
        if (channelName != null) {
            this.errorChannel = (MessageChannel)this.getChannelResolver().resolveDestination(channelName);
            this.errorChannelName = null;
        }
        return this.errorChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    public final void setErrorMessageStrategy(ErrorMessageStrategy errorMessageStrategy) {
        Assert.notNull((Object)errorMessageStrategy, (String)"'errorMessageStrategy' cannot be null");
        this.errorMessageStrategy = errorMessageStrategy;
    }

    protected MessagingTemplate getMessagingTemplate() {
        return this.messagingTemplate;
    }

    public void afterSingletonsInstantiated() {
        Assert.state((this.outputChannel != null || StringUtils.hasText((String)this.outputChannelName) ? 1 : 0) != 0, (String)"'outputChannel' or 'outputChannelName' is required");
    }

    @Override
    protected void onInit() {
        super.onInit();
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory != null) {
            this.messagingTemplate.setBeanFactory(beanFactory);
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    protected void sendMessage(Message<?> messageArg) {
        block4: {
            Message<?> message = messageArg;
            if (message == null) {
                throw new MessagingException("cannot send a null message");
            }
            if (this.shouldTrack) {
                message = MessageHistory.write(message, this, this.getMessageBuilderFactory());
            }
            try {
                MessageChannel messageChannel = this.getOutputChannel();
                Assert.state((messageChannel != null ? 1 : 0) != 0, (String)"The 'outputChannel' or `outputChannelName` must be configured");
                this.messagingTemplate.send(messageChannel, message);
            }
            catch (RuntimeException ex) {
                if (this.sendErrorMessageIfNecessary(message, ex)) break block4;
                throw ex;
            }
        }
    }

    protected final boolean sendErrorMessageIfNecessary(Message<?> message, RuntimeException exception) {
        MessageChannel channel = this.getErrorChannel();
        if (channel != null) {
            this.messagingTemplate.send(channel, (Message)this.buildErrorMessage(message, exception));
            return true;
        }
        return false;
    }

    protected final ErrorMessage buildErrorMessage(Message<?> message, RuntimeException exception) {
        return this.errorMessageStrategy.buildErrorMessage(exception, this.getErrorMessageAttributes(message));
    }

    protected AttributeAccessor getErrorMessageAttributes(Message<?> message) {
        return ErrorMessageUtils.getAttributeAccessor(message, null);
    }
}

