/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.config.MessagingGatewayRegistrar;
import org.springframework.integration.gateway.GatewayMethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GatewayParser
implements BeanDefinitionParser {
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final MessagingGatewayRegistrar registrar = new MessagingGatewayRegistrar();

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        boolean isNested = parserContext.isNested();
        HashMap<String, Object> gatewayAttributes = new HashMap<String, Object>();
        gatewayAttributes.put("name", element.getAttribute("id"));
        gatewayAttributes.put("defaultPayloadExpression", element.getAttribute("default-payload-expression"));
        gatewayAttributes.put("defaultRequestChannel", element.getAttribute(isNested ? "request-channel" : "default-request-channel"));
        gatewayAttributes.put("defaultReplyChannel", element.getAttribute(isNested ? "reply-channel" : "default-reply-channel"));
        gatewayAttributes.put("errorChannel", element.getAttribute("error-channel"));
        String asyncExecutor = element.getAttribute("async-executor");
        if (!element.hasAttribute("async-executor") || StringUtils.hasLength((String)asyncExecutor)) {
            gatewayAttributes.put("asyncExecutor", asyncExecutor);
        } else {
            gatewayAttributes.put("asyncExecutor", null);
        }
        gatewayAttributes.put("mapper", element.getAttribute("mapper"));
        gatewayAttributes.put("defaultReplyTimeout", element.getAttribute(isNested ? "reply-timeout" : "default-reply-timeout"));
        gatewayAttributes.put("defaultRequestTimeout", element.getAttribute(isNested ? "request-timeout" : "default-request-timeout"));
        this.headers(element, gatewayAttributes);
        this.methods(element, parserContext, gatewayAttributes);
        gatewayAttributes.put("serviceInterface", element.getAttribute("service-interface"));
        gatewayAttributes.put("proxyDefaultMethods", element.getAttribute("proxy-default-methods"));
        BeanDefinitionHolder gatewayHolder = this.registrar.gatewayProxyBeanDefinition(gatewayAttributes, parserContext.getRegistry());
        if (isNested) {
            return gatewayHolder.getBeanDefinition();
        }
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)gatewayHolder, (BeanDefinitionRegistry)parserContext.getRegistry());
        return null;
    }

    private void headers(Element element, Map<String, Object> gatewayAttributes) {
        List headerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"default-header");
        if (!CollectionUtils.isEmpty((Collection)headerElements)) {
            ArrayList headers = new ArrayList(headerElements.size());
            for (Element e : headerElements) {
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("name", e.getAttribute("name"));
                header.put("value", e.getAttribute("value"));
                header.put("expression", e.getAttribute("expression"));
                headers.add(header);
            }
            gatewayAttributes.put("defaultHeaders", headers.toArray(new Map[0]));
        }
    }

    private void methods(Element element, ParserContext parserContext, Map<String, Object> gatewayAttributes) {
        List methodElements = DomUtils.getChildElementsByTagName((Element)element, (String)"method");
        if (!CollectionUtils.isEmpty((Collection)methodElements)) {
            ConfigurableBeanFactory beanFactory = GatewayParser.obtainBeanFactory(parserContext.getRegistry());
            HashMap<String, RootBeanDefinition> methodMetadataMap = new HashMap<String, RootBeanDefinition>();
            for (Element methodElement : methodElements) {
                String methodName = methodElement.getAttribute("name");
                RootBeanDefinition gatewayMethodMetadataBd = new RootBeanDefinition(GatewayMethodMetadata.class, () -> this.createGatewayMethodMetadata(element, beanFactory, methodElement));
                methodMetadataMap.put(methodName, gatewayMethodMetadataBd);
            }
            gatewayAttributes.put("methods", methodMetadataMap);
        }
    }

    private static ConfigurableBeanFactory obtainBeanFactory(BeanDefinitionRegistry registry) {
        if (registry instanceof ConfigurableBeanFactory) {
            return (ConfigurableBeanFactory)registry;
        }
        if (registry instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)registry).getBeanFactory();
        }
        throw new IllegalArgumentException("The provided 'BeanDefinitionRegistry' must be an instance of 'ConfigurableBeanFactory' or 'ConfigurableApplicationContext', but given is: " + registry.getClass());
    }

    private GatewayMethodMetadata createGatewayMethodMetadata(Element element, ConfigurableBeanFactory beanFactory, Element methodElement) {
        List invocationHeaders;
        String expressionString;
        EmbeddedValueResolver embeddedValueResolver = new EmbeddedValueResolver(beanFactory);
        GatewayMethodMetadata gatewayMethodMetadata = new GatewayMethodMetadata();
        gatewayMethodMetadata.setRequestChannelName(methodElement.getAttribute("request-channel"));
        gatewayMethodMetadata.setReplyChannelName(methodElement.getAttribute("reply-channel"));
        gatewayMethodMetadata.setRequestTimeout(embeddedValueResolver.resolveStringValue(methodElement.getAttribute("request-timeout")));
        gatewayMethodMetadata.setReplyTimeout(embeddedValueResolver.resolveStringValue(methodElement.getAttribute("reply-timeout")));
        boolean hasMapper = StringUtils.hasText((String)element.getAttribute("mapper"));
        String payloadExpression = methodElement.getAttribute("payload-expression");
        Assert.state((!hasMapper || !StringUtils.hasText((String)payloadExpression) ? 1 : 0) != 0, (String)"'payload-expression' is not allowed when a 'mapper' is provided");
        if (StringUtils.hasText((String)payloadExpression) && (expressionString = embeddedValueResolver.resolveStringValue(payloadExpression)) != null) {
            gatewayMethodMetadata.setPayloadExpression(EXPRESSION_PARSER.parseExpression(expressionString));
        }
        if (!CollectionUtils.isEmpty((Collection)(invocationHeaders = DomUtils.getChildElementsByTagName((Element)methodElement, (String)"header")))) {
            Assert.state((!hasMapper ? 1 : 0) != 0, (String)"header elements are not allowed when a 'mapper' is provided");
            HashMap<String, Expression> headerExpressions = new HashMap<String, Expression>();
            for (Element headerElement : invocationHeaders) {
                String headerValue = headerElement.getAttribute("value");
                String headerExpression = headerElement.getAttribute("expression");
                Expression expression = GatewayParser.buildHeaderExpression(embeddedValueResolver, headerValue, headerExpression);
                headerExpressions.put(headerElement.getAttribute("name"), expression);
            }
            gatewayMethodMetadata.setHeaderExpressions(headerExpressions);
        }
        return gatewayMethodMetadata;
    }

    private static Expression buildHeaderExpression(EmbeddedValueResolver embeddedValueResolver, String headerValue, String headerExpression) {
        if (StringUtils.hasText((String)headerValue)) {
            String resolvedValue = embeddedValueResolver.resolveStringValue(headerValue);
            return resolvedValue != null ? new LiteralExpression(resolvedValue) : null;
        }
        String resolvedValue = embeddedValueResolver.resolveStringValue(headerExpression);
        return resolvedValue != null ? EXPRESSION_PARSER.parseExpression(resolvedValue) : null;
    }
}

