/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs;

import java.io.File;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.StandardRestDocumentationContext;

public final class ManualRestDocumentation
implements RestDocumentationContextProvider {
    private final File outputDirectory;
    private StandardRestDocumentationContext context;

    public ManualRestDocumentation() {
        this(ManualRestDocumentation.getDefaultOutputDirectory());
    }

    public ManualRestDocumentation(String outputDirectory) {
        this(new File(outputDirectory));
    }

    private ManualRestDocumentation(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void beforeTest(Class<?> testClass, String testMethodName) {
        if (this.context != null) {
            throw new IllegalStateException("Context already exists. Did you forget to call afterTest()?");
        }
        this.context = new StandardRestDocumentationContext(testClass, testMethodName, this.outputDirectory);
    }

    public void afterTest() {
        this.context = null;
    }

    @Override
    public RestDocumentationContext beforeOperation() {
        this.context.getAndIncrementStepCount();
        return this.context;
    }

    private static File getDefaultOutputDirectory() {
        if (new File("pom.xml").exists()) {
            return new File("target/generated-snippets");
        }
        return new File("build/generated-snippets");
    }
}

