/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cli;

import java.util.List;
import org.springframework.restdocs.cli.CommandFormatter;
import org.springframework.util.CollectionUtils;

final class ConcatenatingCommandFormatter
implements CommandFormatter {
    private String separator;

    ConcatenatingCommandFormatter(String separator) {
        this.separator = separator;
    }

    @Override
    public String format(List<String> elements) {
        if (CollectionUtils.isEmpty(elements)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String element : elements) {
            result.append(String.format(this.separator, new Object[0]));
            result.append(element);
        }
        return result.toString();
    }
}

