/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.restdocs.cli.CliOperationRequest;
import org.springframework.restdocs.cli.CommandFormatter;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.Parameters;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HttpieRequestSnippet
extends TemplatedSnippet {
    private final CommandFormatter commandFormatter;

    protected HttpieRequestSnippet(CommandFormatter commandFormatter) {
        this(null, commandFormatter);
    }

    protected HttpieRequestSnippet(Map<String, Object> attributes, CommandFormatter commandFormatter) {
        super("httpie-request", attributes);
        Assert.notNull((Object)commandFormatter, (String)"Command formatter must not be null");
        this.commandFormatter = commandFormatter;
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        CliOperationRequest request = new CliOperationRequest(operation.getRequest());
        model.put("echoContent", this.getContentStandardIn(request));
        model.put("options", this.getOptions(request));
        model.put("url", this.getUrl(request));
        model.put("requestItems", this.getRequestItems(request));
        return model;
    }

    private Object getContentStandardIn(CliOperationRequest request) {
        String content = request.getContentAsString();
        if (StringUtils.hasText((String)content)) {
            return String.format("echo '%s' | ", content);
        }
        return "";
    }

    private String getOptions(CliOperationRequest request) {
        StringWriter options = new StringWriter();
        PrintWriter printer = new PrintWriter(options);
        this.writeOptions(request, printer);
        this.writeUserOptionIfNecessary(request, printer);
        this.writeMethodIfNecessary(request, printer);
        return options.toString();
    }

    private String getUrl(OperationRequest request) {
        Parameters uniqueParameters = request.getParameters().getUniqueParameters(request.getUri());
        if (!uniqueParameters.isEmpty() && this.includeParametersInUri(request)) {
            return String.format("'%s%s%s'", request.getUri(), StringUtils.hasText((String)request.getUri().getRawQuery()) ? "&" : "?", uniqueParameters.toQueryString());
        }
        return String.format("'%s'", request.getUri());
    }

    private String getRequestItems(CliOperationRequest request) {
        ArrayList<String> lines = new ArrayList<String>();
        this.writeFormDataIfNecessary(request, lines);
        this.writeHeaders(request, lines);
        this.writeCookies(request, lines);
        this.writeParametersIfNecessary(request, lines);
        return this.commandFormatter.format(lines);
    }

    private void writeOptions(OperationRequest request, PrintWriter writer) {
        if (!request.getParts().isEmpty() || !request.getParameters().getUniqueParameters(request.getUri()).isEmpty() && !this.includeParametersInUri(request) && this.includeParametersAsFormOptions(request)) {
            writer.print("--form ");
        }
    }

    private boolean includeParametersInUri(OperationRequest request) {
        return request.getMethod() == HttpMethod.GET || request.getContent().length > 0 && !MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(request.getHeaders().getContentType());
    }

    private boolean includeParametersAsFormOptions(OperationRequest request) {
        return request.getMethod() != HttpMethod.GET && (request.getContent().length == 0 || !MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(request.getHeaders().getContentType()));
    }

    private void writeUserOptionIfNecessary(CliOperationRequest request, PrintWriter writer) {
        String credentials = request.getBasicAuthCredentials();
        if (credentials != null) {
            writer.print(String.format("--auth '%s' ", credentials));
        }
    }

    private void writeMethodIfNecessary(OperationRequest request, PrintWriter writer) {
        writer.print(String.format("%s", request.getMethod().name()));
    }

    private void writeFormDataIfNecessary(OperationRequest request, List<String> lines) {
        for (OperationRequestPart part : request.getParts()) {
            StringBuilder oneLine = new StringBuilder();
            oneLine.append(String.format("'%s'", part.getName()));
            if (!StringUtils.hasText((String)part.getSubmittedFileName())) {
                oneLine.append(String.format("@<(echo '%s')", part.getContentAsString()));
            } else {
                oneLine.append(String.format("@'%s'", part.getSubmittedFileName()));
            }
            lines.add(oneLine.toString());
        }
    }

    private void writeHeaders(OperationRequest request, List<String> lines) {
        HttpHeaders headers = request.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            for (String header : (List)entry.getValue()) {
                if (!request.getParts().isEmpty() && ((String)entry.getKey()).equals("Content-Type") && header.startsWith("multipart/form-data")) continue;
                lines.add(String.format("'%s:%s'", entry.getKey(), header));
            }
        }
    }

    private void writeCookies(OperationRequest request, List<String> lines) {
        for (RequestCookie cookie : request.getCookies()) {
            lines.add(String.format("'Cookie:%s=%s'", cookie.getName(), cookie.getValue()));
        }
    }

    private void writeParametersIfNecessary(CliOperationRequest request, List<String> lines) {
        if (StringUtils.hasText((String)request.getContentAsString())) {
            return;
        }
        if (!request.getParts().isEmpty()) {
            this.writeContentUsingParameters(request.getParameters(), lines);
        } else if (request.isPutOrPost()) {
            this.writeContentUsingParameters(request.getParameters().getUniqueParameters(request.getUri()), lines);
        }
    }

    private void writeContentUsingParameters(Parameters parameters, List<String> lines) {
        for (Map.Entry entry : parameters.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) {
                lines.add(String.format("'%s='", entry.getKey()));
                continue;
            }
            for (String value : (List)entry.getValue()) {
                lines.add(String.format("'%s=%s'", entry.getKey(), value));
            }
        }
    }
}

