/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

abstract class AbstractOperationMessage {
    private final byte[] content;
    private final HttpHeaders headers;

    AbstractOperationMessage(byte[] content, HttpHeaders headers) {
        this.content = content == null ? new byte[]{} : content;
        this.headers = headers;
    }

    public byte[] getContent() {
        return Arrays.copyOf(this.content, this.content.length);
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.headers);
    }

    public String getContentAsString() {
        if (this.content.length > 0) {
            Charset charset = this.extractCharsetFromContentTypeHeader();
            return charset != null ? new String(this.content, charset) : new String(this.content);
        }
        return "";
    }

    private Charset extractCharsetFromContentTypeHeader() {
        if (this.headers == null) {
            return null;
        }
        MediaType contentType = this.headers.getContentType();
        if (contentType == null) {
            return null;
        }
        return contentType.getCharset();
    }
}

