/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.method;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.expression.OAuth2MethodSecurityExpressionHandler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={OAuth2AccessToken.class})
@ConditionalOnBean(value={GlobalMethodSecurityConfiguration.class})
public class OAuth2MethodSecurityExpressionHandlerConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MethodSecurityExpressionHandler.class})
    MethodSecurityExpressionHandler methodSecurityExpressionHandler(@Autowired ApplicationContext context, @Autowired(required=false) PermissionEvaluator permissionEvaluator, @Autowired(required=false) RoleHierarchy roleHierarchy, @Autowired(required=false) AuthenticationTrustResolver trustResolver, @Autowired(required=false) GrantedAuthorityDefaults grantedAuthorityDefaults) {
        OAuth2MethodSecurityExpressionHandler expressionHandler = new OAuth2MethodSecurityExpressionHandler();
        expressionHandler.setApplicationContext(context);
        if (permissionEvaluator != null) {
            expressionHandler.setPermissionEvaluator(permissionEvaluator);
        }
        if (roleHierarchy != null) {
            expressionHandler.setRoleHierarchy(roleHierarchy);
        }
        if (trustResolver != null) {
            expressionHandler.setTrustResolver(trustResolver);
        }
        if (grantedAuthorityDefaults != null) {
            expressionHandler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
        }
        return expressionHandler;
    }
}

