/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import com.trilead.ssh2.auth.AgentProxy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.SVNSSHPrivateKeyUtil;
import org.tmatesoft.svn.core.internal.io.svn.StreamLogger;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SessionPoolFactory;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshAuthenticationException;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSessionPool;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSSHConnector
implements ISVNConnector {
    private static final String SVNSERVE_COMMAND = "svnserve -t";
    private static final String SVNSERVE_COMMAND_WITH_USER_NAME = "svnserve -t --tunnel-user ";
    private static final boolean ourIsUseSessionPing = Boolean.getBoolean("svnkit.ssh2.ping");
    private static SshSessionPool ourSessionPool = SessionPoolFactory.create();
    private SshSession mySession;
    private InputStream myInputStream;
    private OutputStream myOutputStream;
    private boolean myIsUseSessionPing;

    public SVNSSHConnector() {
        this(true, true);
    }

    public SVNSSHConnector(boolean useConnectionPing, boolean useSessionPing) {
        this.myIsUseSessionPing = useSessionPing;
    }

    @Override
    public void open(SVNRepositoryImpl repository) throws SVNException {
        ISVNAuthenticationManager authManager = repository.getAuthenticationManager();
        if (authManager == null) {
            SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", repository.getLocation());
            return;
        }
        String realm = repository.getLocation().getProtocol() + "://" + repository.getLocation().getHost();
        if (repository.getLocation().hasPort()) {
            realm = realm + ":" + repository.getLocation().getPort();
        }
        if (repository.getLocation().getUserInfo() != null && !"".equals(repository.getLocation().getUserInfo())) {
            realm = repository.getLocation().getUserInfo() + "@" + realm;
        }
        int reconnect = 1;
        while (true) {
            SVNErrorMessage err;
            SVNSSHAuthentication authentication = (SVNSSHAuthentication)authManager.getFirstAuthentication("svn.ssh", realm, repository.getLocation());
            SshSession connection = null;
            while (authentication != null) {
                SVNErrorMessage error;
                try {
                    int readTimeout;
                    int connectTimeout;
                    char[] password;
                    char[] passphrase;
                    char[] privateKey;
                    int port;
                    ISVNSSHHostVerifier verifier = (ISVNSSHHostVerifier)((Object)(authManager instanceof ISVNSSHHostVerifier ? authManager : null));
                    String host = repository.getLocation().getHost();
                    int n = port = repository.getLocation().hasPort() ? repository.getLocation().getPort() : authentication.getPortNumber();
                    if (port < 0) {
                        port = 22;
                    }
                    String userName = authentication.getUserName();
                    char[] cArray = privateKey = authentication.getPrivateKey() != null ? authentication.getPrivateKey() : null;
                    if (privateKey == null && authentication.getPrivateKeyFile() != null) {
                        privateKey = SVNSSHPrivateKeyUtil.readPrivateKey(authentication.getPrivateKeyFile());
                    }
                    if ((passphrase = authentication.getPassphraseValue()) != null && passphrase.length == 0) {
                        passphrase = null;
                    }
                    if ((password = authentication.getPasswordValue()) != null && password.length == 0) {
                        password = null;
                    }
                    AgentProxy agentProxy = authentication.getAgentProxy();
                    if (privateKey != null && !SVNSSHPrivateKeyUtil.isValidPrivateKey(privateKey, authentication.getPassphraseValue())) {
                        if (password == null) {
                            SVNErrorMessage error2 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "File ''{0}'' is not valid OpenSSH DSA or RSA private key file", (Object)authentication.getPrivateKeyFile());
                            SVNErrorManager.error(error2, SVNLogType.NETWORK);
                        }
                        privateKey = null;
                    }
                    if ((connection = ourSessionPool.openSession(host, port, userName, privateKey, passphrase, password, agentProxy, verifier, connectTimeout = authManager.getConnectTimeout(repository), readTimeout = authManager.getReadTimeout(repository))) == null) {
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Cannot connect to ''{0}''", (Object)repository.getLocation().setPath("", false));
                        SVNErrorManager.error(err2, SVNLogType.NETWORK);
                    }
                    BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.ssh", realm, null, authentication, repository.getLocation(), authManager);
                    break;
                }
                catch (SVNAuthenticationException e) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
                    BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.ssh", realm, e.getErrorMessage(), authentication, repository.getLocation(), authManager);
                    authentication = (SVNSSHAuthentication)authManager.getNextAuthentication("svn.ssh", realm, repository.getLocation());
                    connection = null;
                }
                catch (SshAuthenticationException auth) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, auth);
                    error = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, auth.getMessage());
                    BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.ssh", realm, error, authentication, repository.getLocation(), authManager);
                    authentication = (SVNSSHAuthentication)authManager.getNextAuthentication("svn.ssh", realm, repository.getLocation());
                    connection = null;
                }
                catch (IOException e) {
                    connection = null;
                    error = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, e);
                    SVNErrorManager.error(error, SVNLogType.NETWORK);
                }
            }
            if (authentication == null) {
                SVNErrorManager.cancel("authentication cancelled", SVNLogType.NETWORK);
            } else if (connection == null) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Can not establish connection to ''{0}''", (Object)realm), SVNLogType.NETWORK);
            }
            try {
                String userName;
                this.mySession = connection;
                SVNAuthentication author = authManager.getFirstAuthentication("svn.username", realm, repository.getLocation());
                if (author == null) {
                    SVNErrorManager.cancel("authentication cancelled", SVNLogType.NETWORK);
                }
                if ((userName = author.getUserName()) == null || "".equals(userName.trim())) {
                    userName = authentication.getUserName();
                }
                if (author.getUserName() == null || author.getUserName().equals(authentication.getUserName()) || "".equals(author.getUserName())) {
                    repository.setExternalUserName("");
                } else {
                    repository.setExternalUserName(author.getUserName());
                }
                author = new SVNUserNameAuthentication(userName, author.isStorageAllowed(), repository.getLocation(), false);
                BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.username", realm, null, author, repository.getLocation(), authManager);
                if ("".equals(repository.getExternalUserName())) {
                    this.mySession.execCommand(SVNSERVE_COMMAND);
                } else {
                    this.mySession.execCommand("svnserve -t --tunnel-user \"" + repository.getExternalUserName() + "\"");
                }
                this.myOutputStream = this.mySession.getIn();
                this.myOutputStream = new BufferedOutputStream(this.myOutputStream, 16384);
                this.myInputStream = this.mySession.getOut();
                this.myInputStream = new BufferedInputStream(this.myInputStream, 16384);
                StreamLogger.consume(this.mySession.getErr());
                return;
            }
            catch (SocketTimeoutException e) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "timed out waiting for server", null, 0, e);
                SVNErrorManager.error(err, e, SVNLogType.NETWORK);
                continue;
            }
            catch (UnknownHostException e) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "Unknown host " + e.getMessage(), null, 0, e);
                SVNErrorManager.error(err, e, SVNLogType.NETWORK);
                continue;
            }
            catch (ConnectException e) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "connection refused by the server", null, 0, e);
                SVNErrorManager.error(err, e, SVNLogType.NETWORK);
                continue;
            }
            catch (IOException e) {
                if (--reconnect >= 0) {
                    this.mySession.close();
                    continue;
                }
                repository.getDebugLog().logFine(SVNLogType.NETWORK, e);
                this.close(repository);
                err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Cannot connect to ''{0}'': {1}", repository.getLocation().setPath("", false), e.getMessage());
                SVNErrorManager.error(err, e, SVNLogType.NETWORK);
                continue;
            }
            break;
        }
    }

    @Override
    public void close(SVNRepositoryImpl repository) throws SVNException {
        SVNFileUtil.closeFile(this.myOutputStream);
        SVNFileUtil.closeFile(this.myInputStream);
        if (this.mySession != null && this.mySession != null) {
            this.mySession.close();
            this.mySession = null;
        }
        this.mySession = null;
        this.myOutputStream = null;
        this.myInputStream = null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.myInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.myOutputStream;
    }

    @Override
    public boolean isConnected(SVNRepositoryImpl repos) throws SVNException {
        return this.mySession != null && !this.isStale();
    }

    @Override
    public boolean isStale() {
        if (this.mySession == null) {
            return true;
        }
        if (!ourIsUseSessionPing) {
            return false;
        }
        if (!this.myIsUseSessionPing) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "SKIPPING CHANNEL PING, IT HAS BEEN DISABLED");
            return false;
        }
        try {
            this.mySession.ping();
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }

    public static void shutdown() {
        ourSessionPool.shutdown();
    }

    @Override
    public void handleExceptionOnOpen(SVNRepositoryImpl repository, SVNException exception) throws SVNException {
        throw exception;
    }

    public static void recreateSessionPoolForTest() {
        ourSessionPool.shutdown();
        ourSessionPool = SessionPoolFactory.create();
    }
}

