/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.boot.monitor.model;

import cn.pomit.boot.monitor.model.Endpoints;
import cn.pomit.boot.monitor.model.Info;
import cn.pomit.boot.monitor.model.Registration;
import cn.pomit.boot.monitor.model.StatusInfo;
import cn.pomit.boot.monitor.model.Tags;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Instance
implements Serializable {
    private static final long serialVersionUID = -5476210649123305653L;
    private final String id;
    private final long version;
    private final Registration registration;
    private final boolean registered;
    private final StatusInfo statusInfo;
    private final Instant statusTimestamp;
    private final Info info;
    private final Endpoints endpoints;
    private final String buildVersion;
    private final Tags tags;

    private Instance(String id) {
        this(id, -1L, null, false, StatusInfo.ofUnknown(), Instant.EPOCH, Info.empty(), Endpoints.empty(), null, Tags.empty());
    }

    public Instance(String id, @Nullable Registration registration, Endpoints endpoints) {
        this.id = id;
        this.version = -1L;
        this.registration = registration;
        this.registered = true;
        this.statusInfo = StatusInfo.valueOf("UP");
        this.statusTimestamp = Instant.now();
        this.info = Info.empty();
        this.endpoints = endpoints;
        this.buildVersion = null;
        this.tags = Tags.empty();
    }

    private Instance(String id, long version, @Nullable Registration registration, boolean registered, StatusInfo statusInfo, Instant statusTimestamp, Info info, Endpoints endpoints, @Nullable String buildVersion, Tags tags) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Assert.notNull((Object)endpoints, (String)"'endpoints' must not be null");
        Assert.notNull((Object)info, (String)"'info' must not be null");
        Assert.notNull((Object)statusInfo, (String)"'statusInfo' must not be null");
        this.id = id;
        this.version = version;
        this.registration = registration;
        this.registered = registered;
        this.statusInfo = statusInfo;
        this.statusTimestamp = statusTimestamp;
        this.info = info;
        this.endpoints = registered && registration != null ? endpoints.withEndpoint("health", registration.getHealthUrl()) : endpoints;
        this.buildVersion = buildVersion;
        this.tags = tags;
    }

    public static Instance create(String id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        return new Instance(id);
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public Registration getRegistration() {
        if (this.registration == null) {
            throw new IllegalStateException("Application '" + this.id + "' has no valid registration.");
        }
        return this.registration;
    }

    @Nullable
    @SafeVarargs
    private final String updateBuildVersion(Map<String, ?> ... sources) {
        return Arrays.stream(sources).map(s -> Instance.from(s)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static String from(Map<String, ?> map) {
        Object version;
        if (map.isEmpty()) {
            return null;
        }
        Object build = map.get("build");
        if (build instanceof Map && (version = ((Map)build).get("version")) instanceof String) {
            return (String)version;
        }
        version = map.get("build.version");
        if (version instanceof String) {
            return (String)version;
        }
        version = map.get("version");
        if (version instanceof String) {
            return (String)version;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public StatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    public Instant getStatusTimestamp() {
        return this.statusTimestamp;
    }

    public Info getInfo() {
        return this.info;
    }

    public Endpoints getEndpoints() {
        return this.endpoints;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Registration this$registration = this.getRegistration();
        Registration other$registration = other.getRegistration();
        if (this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration)) {
            return false;
        }
        if (this.isRegistered() != other.isRegistered()) {
            return false;
        }
        StatusInfo this$statusInfo = this.getStatusInfo();
        StatusInfo other$statusInfo = other.getStatusInfo();
        if (this$statusInfo == null ? other$statusInfo != null : !((Object)this$statusInfo).equals(other$statusInfo)) {
            return false;
        }
        Instant this$statusTimestamp = this.getStatusTimestamp();
        Instant other$statusTimestamp = other.getStatusTimestamp();
        if (this$statusTimestamp == null ? other$statusTimestamp != null : !((Object)this$statusTimestamp).equals(other$statusTimestamp)) {
            return false;
        }
        Info this$info = this.getInfo();
        Info other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        Endpoints this$endpoints = this.getEndpoints();
        Endpoints other$endpoints = other.getEndpoints();
        if (this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints)) {
            return false;
        }
        String this$buildVersion = this.getBuildVersion();
        String other$buildVersion = other.getBuildVersion();
        if (this$buildVersion == null ? other$buildVersion != null : !this$buildVersion.equals(other$buildVersion)) {
            return false;
        }
        Tags this$tags = this.getTags();
        Tags other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Instance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Registration $registration = this.getRegistration();
        result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
        result = result * 59 + (this.isRegistered() ? 79 : 97);
        StatusInfo $statusInfo = this.getStatusInfo();
        result = result * 59 + ($statusInfo == null ? 43 : ((Object)$statusInfo).hashCode());
        Instant $statusTimestamp = this.getStatusTimestamp();
        result = result * 59 + ($statusTimestamp == null ? 43 : ((Object)$statusTimestamp).hashCode());
        Info $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        Endpoints $endpoints = this.getEndpoints();
        result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
        String $buildVersion = this.getBuildVersion();
        result = result * 59 + ($buildVersion == null ? 43 : $buildVersion.hashCode());
        Tags $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Instance(id=" + this.getId() + ", version=" + this.getVersion() + ", registration=" + this.getRegistration() + ", registered=" + this.isRegistered() + ", statusInfo=" + this.getStatusInfo() + ", statusTimestamp=" + this.getStatusTimestamp() + ", info=" + this.getInfo() + ", endpoints=" + this.getEndpoints() + ", buildVersion=" + this.getBuildVersion() + ", tags=" + this.getTags() + ")";
    }
}

