/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.boot.monitor.ui;

import cn.pomit.boot.monitor.event.InstanceEndpointsDetectedEvent;
import cn.pomit.boot.monitor.event.InstanceEvent;
import cn.pomit.boot.monitor.event.InstanceEventLog;
import cn.pomit.boot.monitor.event.InstanceRegisteredEvent;
import cn.pomit.boot.monitor.event.InstanceStatusChangedEvent;
import cn.pomit.boot.monitor.model.Application;
import cn.pomit.boot.monitor.model.Endpoints;
import cn.pomit.boot.monitor.model.Instance;
import cn.pomit.boot.monitor.model.Registration;
import cn.pomit.boot.monitor.model.UserInfo;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor"})
public class ApplicationController {
    private Collection<? extends ExposableEndpoint<?>> endpoints;
    private Application application;
    private UserInfo userInfo;
    private InstanceEventLog instanceEventLog;

    public ApplicationController(Collection<? extends ExposableEndpoint<?>> endpoints, Application application, InstanceEventLog instanceEventLog, UserInfo userInfo) {
        this.endpoints = endpoints;
        this.application = application;
        this.instanceEventLog = instanceEventLog;
        this.userInfo = userInfo;
    }

    @ResponseBody
    @GetMapping(path={"/applications"}, produces={"application/json"})
    public List<Application> applications(@CookieValue(name="moni_id", required=false) String monitorId, HttpServletRequest request, HttpServletResponse response) {
        if (!(this.userInfo.getUserName() == null || this.userInfo.getPassword() == null || monitorId != null && monitorId.equals(this.userInfo.getUserNameToken()))) {
            response.setStatus(401);
            return null;
        }
        this.initApplicationInfo(request);
        return Arrays.asList(this.application);
    }

    public void initApplicationInfo(HttpServletRequest request) {
        String normalizedUrl = this.normalizeRequestUrl(request);
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        for (ExposableEndpoint<?> endpoint : this.endpoints) {
            if (endpoint instanceof ExposableWebEndpoint) {
                this.collectLinks(links, (ExposableWebEndpoint)endpoint, normalizedUrl);
                continue;
            }
            if (!(endpoint instanceof PathMappedEndpoint)) continue;
            links.put(endpoint.getId(), this.createLink(normalizedUrl, ((PathMappedEndpoint)endpoint).getRootPath()));
        }
        Endpoints endpoints = new Endpoints(links);
        Registration registration = new Registration(this.application.getName(), normalizedUrl, normalizedUrl + "/health", this.hostUrl(request), "http-api");
        Instance instance = new Instance(this.application.getName(), registration, endpoints);
        this.application.setInstances(Arrays.asList(instance));
        if (!this.instanceEventLog.isHasInit()) {
            InstanceRegisteredEvent instanceRegisteredEvent = new InstanceRegisteredEvent(this.application.getName(), 0L, Instant.now(), registration);
            this.instanceEventLog.add(instanceRegisteredEvent);
            InstanceStatusChangedEvent instanceStatusChangedEvent = new InstanceStatusChangedEvent(this.application.getName(), 1L, Instant.now(), instance.getStatusInfo());
            this.instanceEventLog.add(instanceStatusChangedEvent);
            InstanceEndpointsDetectedEvent instanceEndpointsDetectedEvent = new InstanceEndpointsDetectedEvent(this.application.getName(), 2L, Instant.now(), endpoints);
            this.instanceEventLog.add(instanceEndpointsDetectedEvent);
            this.instanceEventLog.setHasInit(true);
        }
    }

    @ResponseBody
    @GetMapping(path={"/applications"}, produces={"text/event-stream"})
    public List<Application> applicationsStream(HttpServletRequest request, HttpServletResponse response) {
        this.initApplicationInfo(request);
        return Arrays.asList(this.application);
    }

    @ResponseBody
    @GetMapping(path={"instances/events"}, produces={"application/json"})
    public List<InstanceEvent> events(HttpServletRequest request, HttpServletResponse response) {
        if (!this.instanceEventLog.isHasInit()) {
            return Collections.emptyList();
        }
        return this.instanceEventLog.getEventList();
    }

    @ResponseBody
    @GetMapping(path={"instances/events"}, produces={"text/event-stream"})
    public List<ServerSentEvent<InstanceEvent>> eventsStream(HttpServletRequest request, HttpServletResponse response) {
        if (!this.instanceEventLog.isHasInit()) {
            return Collections.emptyList();
        }
        ArrayList<ServerSentEvent<InstanceEvent>> retList = new ArrayList<ServerSentEvent<InstanceEvent>>();
        for (InstanceEvent event : this.instanceEventLog.getEventList()) {
            retList.add((ServerSentEvent<InstanceEvent>)ServerSentEvent.builder((Object)event).build());
        }
        return retList;
    }

    private String normalizeRequestUrl(HttpServletRequest request) {
        String uri = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri + "actuator";
    }

    private String hostUrl(HttpServletRequest request) {
        String uri = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri;
    }

    private void collectLinks(Map<String, Link> links, ExposableWebEndpoint endpoint, String normalizedUrl) {
        for (WebOperation operation : endpoint.getOperations()) {
            links.put(operation.getId(), this.createLink(normalizedUrl, operation));
        }
    }

    private Link createLink(String requestUrl, WebOperation operation) {
        return this.createLink(requestUrl, operation.getRequestPredicate().getPath());
    }

    private Link createLink(String requestUrl, String path) {
        return new Link(requestUrl + (path.startsWith("/") ? path : "/" + path));
    }
}

