/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.codec.data;

import com.alibaba.csp.sentinel.cluster.codec.EntityWriter;
import com.alibaba.csp.sentinel.cluster.request.data.ParamFlowRequestData;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Iterator;

public class ParamFlowRequestDataWriter
implements EntityWriter<ParamFlowRequestData, ByteBuf> {
    private static final int PARAM_MAX_SIZE = 1000;

    public void writeTo(ParamFlowRequestData entity, ByteBuf target) {
        target.writeLong(entity.getFlowId());
        target.writeInt(entity.getCount());
        Collection params = entity.getParams();
        int amount = this.calculateParamAmount(params);
        target.writeInt(amount);
        for (Object param : entity.getParams()) {
            this.encodeValue(param, target);
        }
    }

    private void encodeValue(Object param, ByteBuf target) {
        if (param instanceof Integer || Integer.TYPE.isInstance(param)) {
            target.writeByte(0);
            target.writeInt(((Integer)param).intValue());
        } else if (param instanceof String) {
            this.encodeString((String)param, target);
        } else if (Boolean.TYPE.isInstance(param) || param instanceof Boolean) {
            target.writeByte(6);
            target.writeBoolean(((Boolean)param).booleanValue());
        } else if (Long.TYPE.isInstance(param) || param instanceof Long) {
            target.writeByte(1);
            target.writeLong(((Long)param).longValue());
        } else if (Double.TYPE.isInstance(param) || param instanceof Double) {
            target.writeByte(3);
            target.writeDouble(((Double)param).doubleValue());
        } else if (Float.TYPE.isInstance(param) || param instanceof Float) {
            target.writeByte(4);
            target.writeFloat(((Float)param).floatValue());
        } else if (Byte.TYPE.isInstance(param) || param instanceof Byte) {
            target.writeByte(2);
            target.writeByte((int)((Byte)param).byteValue());
        } else if (Short.TYPE.isInstance(param) || param instanceof Short) {
            target.writeByte(5);
            target.writeShort((int)((Short)param).shortValue());
        }
    }

    private void encodeString(String param, ByteBuf target) {
        target.writeByte(7);
        byte[] tmpChars = param.getBytes();
        target.writeInt(tmpChars.length);
        target.writeBytes(tmpChars);
    }

    private int calculateParamAmount(Collection<Object> params) {
        Object param;
        int s;
        int size = 0;
        int length = 0;
        Iterator<Object> iterator = params.iterator();
        while (iterator.hasNext() && size + (s = this.calculateParamTransportSize(param = iterator.next())) <= 1000) {
            ++length;
        }
        return length;
    }

    private int calculateParamTransportSize(Object value) {
        if (value instanceof Integer || Integer.TYPE.isInstance(value)) {
            return 5;
        }
        if (value instanceof String) {
            String tmpValue = (String)value;
            byte[] tmpChars = tmpValue.getBytes();
            return 5 + tmpChars.length;
        }
        if (Boolean.TYPE.isInstance(value) || value instanceof Boolean) {
            return 2;
        }
        if (Long.TYPE.isInstance(value) || value instanceof Long) {
            return 9;
        }
        if (Double.TYPE.isInstance(value) || value instanceof Double) {
            return 9;
        }
        if (Float.TYPE.isInstance(value) || value instanceof Float) {
            return 5;
        }
        if (Byte.TYPE.isInstance(value) || value instanceof Byte) {
            return 2;
        }
        if (Short.TYPE.isInstance(value) || value instanceof Short) {
            return 3;
        }
        return 0;
    }
}

