/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.metric;

import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterParameterLeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.LongAdder;
import com.alibaba.csp.sentinel.slots.statistic.cache.CacheMap;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.List;

public class ClusterParamMetric {
    public static final int DEFAULT_CLUSTER_MAX_CAPACITY = 4000;
    private final ClusterParameterLeapArray<LongAdder> metric;

    public ClusterParamMetric(int sampleCount, int intervalInMs) {
        this(sampleCount, intervalInMs, 4000);
    }

    public ClusterParamMetric(int sampleCount, int intervalInMs, int maxCapacity) {
        AssertUtil.isTrue((sampleCount > 0 ? 1 : 0) != 0, (String)"sampleCount should be positive");
        AssertUtil.isTrue((intervalInMs > 0 ? 1 : 0) != 0, (String)"interval should be positive");
        AssertUtil.isTrue((intervalInMs % sampleCount == 0 ? 1 : 0) != 0, (String)"time span needs to be evenly divided");
        int windowLengthInMs = intervalInMs / sampleCount;
        this.metric = new ClusterParameterLeapArray(windowLengthInMs, intervalInMs, maxCapacity);
    }

    public long getSum(Object value) {
        if (value == null) {
            return 0L;
        }
        this.metric.currentWindow();
        long sum = 0L;
        List buckets = this.metric.values();
        for (CacheMap bucket : buckets) {
            long count = this.getCount((LongAdder)bucket.get(value));
            sum += count;
        }
        return sum;
    }

    private long getCount(LongAdder adder) {
        return adder == null ? 0L : adder.sum();
    }

    public void addValue(Object value, int count) {
        LongAdder newCounter;
        if (value == null) {
            return;
        }
        CacheMap data = (CacheMap)this.metric.currentWindow().value();
        LongAdder currentCounter = (LongAdder)data.putIfAbsent(value, (Object)(newCounter = new LongAdder()));
        if (currentCounter != null) {
            currentCounter.add((long)count);
        } else {
            newCounter.add((long)count);
        }
    }

    public double getAvg(Object value) {
        return this.getSum(value) / (long)this.metric.getIntervalInSecond();
    }
}

