/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.data;

import com.alibaba.csp.sentinel.slots.block.flow.param.RollingParamEvent;
import com.alibaba.csp.sentinel.slots.statistic.cache.CacheMap;
import com.alibaba.csp.sentinel.slots.statistic.cache.ConcurrentLinkedHashMapWrapper;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ParamMapBucket {
    private final CacheMap<Object, AtomicInteger>[] data;
    public static final int DEFAULT_MAX_CAPACITY = 200;

    public ParamMapBucket() {
        this(200);
    }

    public ParamMapBucket(int capacity) {
        AssertUtil.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"capacity should be positive");
        RollingParamEvent[] events = RollingParamEvent.values();
        this.data = new CacheMap[events.length];
        for (RollingParamEvent event : events) {
            this.data[event.ordinal()] = new ConcurrentLinkedHashMapWrapper<Object, AtomicInteger>(capacity);
        }
    }

    public void reset() {
        for (RollingParamEvent event : RollingParamEvent.values()) {
            this.data[event.ordinal()].clear();
        }
    }

    public int get(RollingParamEvent event, Object value) {
        AtomicInteger counter = this.data[event.ordinal()].get(value);
        return counter == null ? 0 : counter.intValue();
    }

    public ParamMapBucket add(RollingParamEvent event, int count, Object value) {
        this.data[event.ordinal()].putIfAbsent(value, new AtomicInteger());
        AtomicInteger counter = this.data[event.ordinal()].get(value);
        counter.addAndGet(count);
        return this;
    }

    public Set<Object> ascendingKeySet(RollingParamEvent type) {
        return this.data[type.ordinal()].keySet(true);
    }

    public Set<Object> descendingKeySet(RollingParamEvent type) {
        return this.data[type.ordinal()].keySet(false);
    }
}

