/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.dubbo.telnet;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.PojoUtils;
import com.alibaba.dubbo.common.utils.ReflectUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.telnet.TelnetHandler;
import com.alibaba.dubbo.remoting.telnet.support.Help;
import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.protocol.dubbo.DubboProtocol;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Activate
@Help(parameter="[service.]method(args)", summary="Invoke the service method.", detail="Invoke the service method.")
public class InvokeTelnetHandler
implements TelnetHandler {
    static final String INVOKE_MESSAGE_KEY = "telnet.invoke.method.message";
    static final String INVOKE_METHOD_LIST_KEY = "telnet.invoke.method.list";

    @Override
    public String telnet(Channel channel, String message) {
        List list;
        int i;
        if (message == null || message.length() == 0) {
            return "Please input method name, eg: \r\ninvoke xxxMethod(1234, \"abcd\", {\"prop\" : \"value\"})\r\ninvoke XxxService.xxxMethod(1234, \"abcd\", {\"prop\" : \"value\"})\r\ninvoke com.xxx.XxxService.xxxMethod(1234, \"abcd\", {\"prop\" : \"value\"})";
        }
        StringBuilder buf = new StringBuilder();
        String service = (String)channel.getAttribute("telnet.service");
        if (service != null && service.length() > 0) {
            buf.append("Use default service " + service + ".\r\n");
        }
        if ((i = message.indexOf("(")) < 0 || !message.endsWith(")")) {
            return "Invalid parameters, format: service.method(args)";
        }
        String method = message.substring(0, i).trim();
        String args = message.substring(i + 1, message.length() - 1).trim();
        i = method.lastIndexOf(".");
        if (i >= 0) {
            service = method.substring(0, i).trim();
            method = method.substring(i + 1).trim();
        }
        try {
            list = JSON.parseArray((String)("[" + args + "]"), Object.class);
        }
        catch (Throwable t) {
            return "Invalid json argument, cause: " + t.getMessage();
        }
        Invoker<?> invoker = null;
        Method invokeMethod = null;
        Collection<Exporter<?>> exporters = DubboProtocol.getDubboProtocol().getExporters();
        if (this.isInvokedSelectCommand(channel)) {
            invokeMethod = (Method)channel.getAttribute("telnet.select.method");
            for (Exporter<?> exporter : exporters) {
                if (!invokeMethod.getDeclaringClass().getName().equals(exporter.getInvoker().getInterface().getName())) continue;
                invoker = exporter.getInvoker();
                break;
            }
        } else {
            if (StringUtils.isBlank(service) && exporters.size() != 1) {
                return "Failed to find service !";
            }
            for (Exporter<?> exporter : exporters) {
                if (!StringUtils.isBlank(service) && !service.equals(exporter.getInvoker().getInterface().getSimpleName()) && !service.equals(exporter.getInvoker().getInterface().getName()) && !service.equals(exporter.getInvoker().getUrl().getPath())) continue;
                invoker = exporter.getInvoker();
                List<Method> methodList = this.findSameSignatureMethod(exporter.getInvoker().getInterface(), method, list);
                if (!CollectionUtils.isNotEmpty(methodList)) break;
                if (methodList.size() == 1) {
                    invokeMethod = methodList.get(0);
                    break;
                }
                List<Method> matchMethods = this.findMatchMethods(methodList, list);
                if (!CollectionUtils.isNotEmpty(matchMethods)) break;
                if (matchMethods.size() == 1) {
                    invokeMethod = matchMethods.get(0);
                    break;
                }
                channel.setAttribute(INVOKE_METHOD_LIST_KEY, matchMethods);
                channel.setAttribute(INVOKE_MESSAGE_KEY, message);
                this.printSelectMessage(buf, matchMethods);
                return buf.toString();
            }
        }
        if (invoker != null) {
            if (invokeMethod != null) {
                try {
                    Object[] array = PojoUtils.realize(list.toArray(), invokeMethod.getParameterTypes(), invokeMethod.getGenericParameterTypes());
                    RpcContext.getContext().setLocalAddress(channel.getLocalAddress()).setRemoteAddress(channel.getRemoteAddress());
                    long start = System.currentTimeMillis();
                    Object result = invoker.invoke(new RpcInvocation(invokeMethod, array)).recreate();
                    long end = System.currentTimeMillis();
                    buf.append(JSON.toJSONString((Object)result));
                    buf.append("\r\nelapsed: ");
                    buf.append(end - start);
                    buf.append(" ms.");
                }
                catch (Throwable t) {
                    return "Failed to invoke method " + invokeMethod.getName() + ", cause: " + StringUtils.toString(t);
                }
            } else {
                buf.append("No such method " + method + " in service " + service);
            }
        } else {
            buf.append("No such service " + service);
        }
        return buf.toString();
    }

    private List<Method> findSameSignatureMethod(Class clazz, String lookupMethodName, List<Object> args) {
        Method[] declaredMethods;
        ArrayList<Method> sameSignatureMethods = new ArrayList<Method>();
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(lookupMethodName) || method.getParameterTypes().length != args.size()) continue;
            sameSignatureMethods.add(method);
        }
        return sameSignatureMethods;
    }

    private List<Method> findMatchMethods(List<Method> methods, List<Object> args) {
        ArrayList<Method> matchMethod = new ArrayList<Method>();
        for (Method method : methods) {
            if (!InvokeTelnetHandler.isMatch(method, args)) continue;
            matchMethod.add(method);
        }
        return matchMethod;
    }

    private static boolean isMatch(Method method, List<Object> args) {
        Class<?>[] types = method.getParameterTypes();
        if (types.length != args.size()) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            Object arg = args.get(i);
            if (arg == null) {
                if (!type.isPrimitive()) continue;
                return false;
            }
            if (ReflectUtils.isPrimitive(arg.getClass())) {
                if (arg instanceof String && type.isEnum()) continue;
                if (!ReflectUtils.isPrimitive(type)) {
                    return false;
                }
                if (ReflectUtils.isCompatible(type, arg)) continue;
                return false;
            }
            if (arg instanceof Map) {
                String name = (String)((Map)arg).get("class");
                if (StringUtils.isNotEmpty(name)) {
                    Class<?> cls = ReflectUtils.forName(name);
                    if (type.isAssignableFrom(cls)) continue;
                    return false;
                }
                return true;
            }
            if (!(arg instanceof Collection ? !type.isArray() && !type.isAssignableFrom(arg.getClass()) : !type.isAssignableFrom(arg.getClass()))) continue;
            return false;
        }
        return true;
    }

    private void printSelectMessage(StringBuilder buf, List<Method> methods) {
        buf.append("Methods:\r\n");
        for (int i = 0; i < methods.size(); ++i) {
            Method method = methods.get(i);
            buf.append(i + 1).append(". ").append(method.getName()).append("(");
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int n = 0; n < parameterTypes.length; ++n) {
                buf.append(parameterTypes[n].getSimpleName());
                if (n == parameterTypes.length - 1) continue;
                buf.append(",");
            }
            buf.append(")\r\n");
        }
        buf.append("Please use the select command to select the method you want to invoke. eg: select 1");
    }

    private boolean isInvokedSelectCommand(Channel channel) {
        if (channel.hasAttribute("telnet.select")) {
            channel.removeAttribute("telnet.select");
            return true;
        }
        return false;
    }
}

