/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.data.redis;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class GenericFastJsonJSONBRedisSerializer
implements RedisSerializer<Object> {
    private final FastJsonConfig fastJsonConfig = new FastJsonConfig();

    public GenericFastJsonJSONBRedisSerializer() {
        this.fastJsonConfig.setReaderFeatures(JSONReader.Feature.SupportAutoType);
        this.fastJsonConfig.setWriterFeatures(JSONWriter.Feature.WriteClassName);
    }

    public byte[] serialize(Object object) throws SerializationException {
        if (object == null) {
            return new byte[0];
        }
        try {
            return JSONB.toBytes((Object)object, (JSONWriter.Feature[])this.fastJsonConfig.getWriterFeatures());
        }
        catch (Exception ex) {
            throw new SerializationException("Could not serialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return JSONB.parseObject((byte[])bytes, Object.class, (JSONReader.Feature[])this.fastJsonConfig.getReaderFeatures());
        }
        catch (Exception ex) {
            throw new SerializationException("Could not deserialize: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

