/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util;

import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipayLogger;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntCertificationUtil {
    private static BouncyCastleProvider provider = new BouncyCastleProvider();

    public static boolean isTrusted(String cert, String rootCertContent) {
        X509Certificate[] certificates;
        try {
            certificates = AntCertificationUtil.readPemCertChain(cert);
        }
        catch (Exception e) {
            AlipayLogger.logBizError("\u8bfb\u53d6\u8bc1\u4e66\u5931\u8d25");
            throw new RuntimeException(e);
        }
        ArrayList<X509Certificate> rootCerts = new ArrayList<X509Certificate>();
        try {
            X509Certificate[] certs;
            for (X509Certificate c : certs = AntCertificationUtil.readPemCertChain(rootCertContent)) {
                rootCerts.add(c);
            }
        }
        catch (Exception e) {
            AlipayLogger.logBizError("\u8bfb\u53d6\u6839\u8bc1\u4e66\u5931\u8d25");
            throw new RuntimeException(e);
        }
        boolean result = AntCertificationUtil.verifyCertChain(certificates, rootCerts.toArray(new X509Certificate[rootCerts.size()]));
        return result;
    }

    private static boolean verifyCert(X509Certificate cert, X509Certificate[] rootCerts) {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            AlipayLogger.logBizError("\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f");
            return false;
        }
        catch (CertificateNotYetValidException e) {
            AlipayLogger.logBizError("\u8bc1\u4e66\u672a\u6fc0\u6d3b");
            return false;
        }
        HashMap<Principal, X509Certificate> subjectMap = new HashMap<Principal, X509Certificate>();
        for (X509Certificate root : rootCerts) {
            subjectMap.put(root.getSubjectDN(), root);
        }
        Principal issuerDN = cert.getIssuerDN();
        X509Certificate issuer = (X509Certificate)subjectMap.get(issuerDN);
        if (issuer == null) {
            AlipayLogger.logBizError("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25");
            return false;
        }
        try {
            PublicKey publicKey = issuer.getPublicKey();
            AntCertificationUtil.verifySignature(publicKey, cert);
        }
        catch (Exception e) {
            AlipayLogger.logBizError("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25");
            return false;
        }
        return true;
    }

    private static boolean verifyCertChain(X509Certificate[] certs, X509Certificate[] rootCerts) {
        boolean sorted = AntCertificationUtil.sortByDn(certs);
        if (!sorted) {
            AlipayLogger.logBizError("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25\uff1a\u4e0d\u662f\u5b8c\u6574\u7684\u8bc1\u4e66\u94fe");
            return false;
        }
        X509Certificate prev = certs[0];
        boolean firstOK = AntCertificationUtil.verifyCert(prev, rootCerts);
        if (!firstOK || certs.length == 1) {
            return firstOK;
        }
        for (int i = 1; i < certs.length; ++i) {
            try {
                X509Certificate cert = certs[i];
                try {
                    cert.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    AlipayLogger.logBizError("\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f");
                    return false;
                }
                catch (CertificateNotYetValidException e) {
                    AlipayLogger.logBizError("\u8bc1\u4e66\u672a\u6fc0\u6d3b");
                    return false;
                }
                AntCertificationUtil.verifySignature(prev.getPublicKey(), cert);
                prev = cert;
                continue;
            }
            catch (Exception e) {
                AlipayLogger.logBizError("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25");
                return false;
            }
        }
        return true;
    }

    private static void verifySignature(PublicKey publicKey, X509Certificate cert) throws NoSuchProviderException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        cert.verify(publicKey, provider.getName());
    }

    private static boolean sortByDn(X509Certificate[] certs) {
        HashMap<Principal, X509Certificate> subjectMap = new HashMap<Principal, X509Certificate>();
        HashMap<Principal, X509Certificate> issuerMap = new HashMap<Principal, X509Certificate>();
        boolean hasSelfSignedCert = false;
        for (X509Certificate cert : certs) {
            if (AntCertificationUtil.isSelfSigned(cert)) {
                if (hasSelfSignedCert) {
                    return false;
                }
                hasSelfSignedCert = true;
            }
            Principal subjectDN = cert.getSubjectDN();
            Principal issuerDN = cert.getIssuerDN();
            subjectMap.put(subjectDN, cert);
            issuerMap.put(issuerDN, cert);
        }
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        X509Certificate current = certs[0];
        AntCertificationUtil.addressingUp(subjectMap, certChain, current);
        AntCertificationUtil.addressingDown(issuerMap, certChain, current);
        if (certs.length != certChain.size()) {
            return false;
        }
        for (int i = 0; i < certChain.size(); ++i) {
            certs[i] = (X509Certificate)certChain.get(i);
        }
        return true;
    }

    private static boolean isSelfSigned(X509Certificate cert) {
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    private static void addressingUp(Map<Principal, X509Certificate> subjectMap, List<X509Certificate> certChain, X509Certificate current) {
        certChain.add(0, current);
        if (AntCertificationUtil.isSelfSigned(current)) {
            return;
        }
        Principal issuerDN = current.getIssuerDN();
        X509Certificate issuer = subjectMap.get(issuerDN);
        if (issuer == null) {
            return;
        }
        AntCertificationUtil.addressingUp(subjectMap, certChain, issuer);
    }

    private static void addressingDown(Map<Principal, X509Certificate> issuerMap, List<X509Certificate> certChain, X509Certificate current) {
        Principal subjectDN = current.getSubjectDN();
        X509Certificate subject = issuerMap.get(subjectDN);
        if (subject == null) {
            return;
        }
        if (AntCertificationUtil.isSelfSigned(subject)) {
            return;
        }
        certChain.add(subject);
        AntCertificationUtil.addressingDown(issuerMap, certChain, subject);
    }

    private static X509Certificate[] readPemCertChain(String cert) throws CertificateException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(cert.getBytes());
        CertificateFactory factory = CertificateFactory.getInstance("X.509", (Provider)provider);
        Collection<? extends Certificate> certificates = factory.generateCertificates(inputStream);
        return certificates.toArray(new X509Certificate[certificates.size()]);
    }

    public static String getRootCertSN(String rootCertContent) {
        String rootCertSN = null;
        try {
            X509Certificate[] x509Certificates = AntCertificationUtil.readPemCertChain(rootCertContent);
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (X509Certificate c : x509Certificates) {
                if (!c.getSigAlgOID().startsWith("1.2.840.113549.1.1")) continue;
                md.update((c.getIssuerX500Principal().getName() + c.getSerialNumber()).getBytes());
                String certSN = new BigInteger(1, md.digest()).toString(16);
                certSN = AntCertificationUtil.fillMD5(certSN);
                rootCertSN = StringUtils.isEmpty(rootCertSN) ? certSN : rootCertSN + "_" + certSN;
            }
        }
        catch (Exception e) {
            AlipayLogger.logBizError("\u63d0\u53d6\u6839\u8bc1\u4e66\u5931\u8d25");
        }
        return rootCertSN;
    }

    public static String getRootCertSN(String rootCertContent, String signType) {
        if ("SM2".equals(signType)) {
            String rootCertSN = null;
            try {
                X509Certificate[] x509Certificates = AntCertificationUtil.readPemCertChain(rootCertContent);
                MessageDigest md = MessageDigest.getInstance("MD5");
                for (X509Certificate c : x509Certificates) {
                    if (!c.getSigAlgOID().startsWith("1.2.156.10197.1.501")) continue;
                    md.update((c.getIssuerX500Principal().getName() + c.getSerialNumber()).getBytes());
                    String certSN = new BigInteger(1, md.digest()).toString(16);
                    certSN = AntCertificationUtil.fillMD5(certSN);
                    rootCertSN = StringUtils.isEmpty(rootCertSN) ? certSN : rootCertSN + "_" + certSN;
                }
            }
            catch (Exception e) {
                AlipayLogger.logBizError("\u63d0\u53d6\u6839\u8bc1\u4e66\u5931\u8d25");
            }
            return rootCertSN;
        }
        return AntCertificationUtil.getRootCertSN(rootCertContent);
    }

    private static String fillMD5(String md5) {
        return md5.length() == 32 ? md5 : AntCertificationUtil.fillMD5("0" + md5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate getCertFromPath(String certPath) throws AlipayApiException {
        X509Certificate x509Certificate;
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(certPath);
                CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
                x509Certificate = (X509Certificate)cf.generateCertificate(inputStream);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new AlipayApiException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (inputStream == null) throw throwable;
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new AlipayApiException(e2);
            }
        }
        try {}
        catch (IOException e2) {
            throw new AlipayApiException(e2);
        }
        if (inputStream == null) return x509Certificate;
        ((InputStream)inputStream).close();
        return x509Certificate;
    }

    public static X509Certificate getCertFromContent(String certContent) throws AlipayApiException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(certContent.getBytes());
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            return (X509Certificate)cf.generateCertificate(inputStream);
        }
        catch (Exception e) {
            throw new AlipayApiException(e);
        }
    }

    public static String getCertSN(X509Certificate cf) throws AlipayApiException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update((cf.getIssuerX500Principal().getName() + cf.getSerialNumber()).getBytes());
            String certSN = new BigInteger(1, md.digest()).toString(16);
            certSN = AntCertificationUtil.fillMD5(certSN);
            return certSN;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlipayApiException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAlipayPublicKey(String alipayPublicCertPath) throws AlipayApiException {
        String string;
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(alipayPublicCertPath);
                CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
                PublicKey publicKey = cert.getPublicKey();
                string = Base64.encodeBase64String(publicKey.getEncoded());
                Object var7_9 = null;
            }
            catch (NoSuchProviderException e) {
                throw new AlipayApiException(e);
            }
            catch (IOException e) {
                throw new AlipayApiException(e);
            }
            catch (CertificateException e) {
                throw new AlipayApiException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                if (inputStream == null) throw throwable;
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new AlipayApiException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        if (inputStream == null) return string;
        ((InputStream)inputStream).close();
        return string;
    }

    static {
        Security.addProvider((Provider)provider);
    }
}

