/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.proxy;

import com.alipay.sofa.common.log.MultiAppLoggerSpaceManager;
import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.proxy.LoggerProxy;
import com.alipay.sofa.common.utils.AssertUtil;
import org.slf4j.Logger;

public class TemporaryILoggerFactory
extends AbstractLoggerSpaceFactory {
    private final String space;
    private final ClassLoader spaceClassLoader;
    private final Logger tempLogger;
    private final SpaceId spaceId;
    private LoggerSelector loggerSelector;

    public TemporaryILoggerFactory(String space, ClassLoader spaceClassLoader, Logger tempLogger) {
        this(new SpaceId(space), spaceClassLoader, tempLogger);
    }

    public TemporaryILoggerFactory(SpaceId spaceId, ClassLoader spaceClassLoader, Logger tempLogger) {
        super("temp");
        AssertUtil.notNull(spaceId);
        AssertUtil.notNull(spaceClassLoader);
        AssertUtil.notNull(tempLogger);
        this.space = spaceId.getSpaceName();
        this.spaceId = spaceId;
        this.spaceClassLoader = spaceClassLoader;
        this.tempLogger = tempLogger;
        this.loggerSelector = this.buildLoggerSelector();
        AssertUtil.notNull(this.loggerSelector);
    }

    protected LoggerSelector buildLoggerSelector() {
        return new LoggerSelector();
    }

    public Logger getLogger(String name) {
        return new LoggerProxy(this.loggerSelector, name);
    }

    public class LoggerSelector {
        private boolean warned = false;

        public Logger select(String name) {
            if (!this.isSpaceInitialized()) {
                if (!this.warned) {
                    TemporaryILoggerFactory.this.tempLogger.warn(">>> Logger Space:{} has not be initialized! Use app logger temporary\uff01", (Object)TemporaryILoggerFactory.this.space);
                    this.warned = true;
                }
                return TemporaryILoggerFactory.this.tempLogger;
            }
            if (this.warned) {
                TemporaryILoggerFactory.this.tempLogger.info("<<< Logger Space:{} was initialized! Use this space logger.", (Object)TemporaryILoggerFactory.this.space);
                this.warned = false;
            }
            return this.getLoggerBySpace(name);
        }

        protected Logger getLoggerBySpace(String name) {
            return MultiAppLoggerSpaceManager.getLoggerBySpace(name, TemporaryILoggerFactory.this.spaceId, TemporaryILoggerFactory.this.spaceClassLoader);
        }

        protected boolean isSpaceInitialized() {
            return MultiAppLoggerSpaceManager.isSpaceInitialized(TemporaryILoggerFactory.this.spaceId);
        }
    }
}

