/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AddressHolder;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.log.LogCodes;

public class AddressHolderFactory {
    public static AddressHolder getAddressHolder(ConsumerBootstrap consumerBootstrap) {
        String addressHolder = null;
        try {
            addressHolder = consumerBootstrap.getConsumerConfig().getAddressHolder();
            ExtensionClass<AddressHolder> ext = ExtensionLoaderFactory.getExtensionLoader(AddressHolder.class).getExtensionClass(addressHolder);
            if (ext == null) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("020060003", addressHolder));
            }
            return ext.getExtInstance(new Class[]{ConsumerBootstrap.class}, new Object[]{consumerBootstrap});
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020060003", addressHolder), e);
        }
    }
}

