/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.sofahessian;

import com.alipay.sofa.rpc.common.SofaConfigs;
import com.alipay.sofa.rpc.common.utils.IOUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class BlackListFileLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlackListFileLoader.class);
    public static final List<String> SOFA_SERIALIZE_BLACK_LIST = BlackListFileLoader.loadFile("/sofa-rpc/serialize_blacklist.txt");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> loadFile(String path) {
        ArrayList<String> blackPrefixList = new ArrayList<String>();
        InputStream input = null;
        try {
            String overStr;
            input = BlackListFileLoader.class.getResourceAsStream(path);
            if (input != null) {
                BlackListFileLoader.readToList(input, "UTF-8", blackPrefixList);
            }
            if (StringUtils.isNotBlank(overStr = SofaConfigs.getStringValue("rpc_serialize_blacklist_override", ""))) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Serialize blacklist will override with configuration: {}", overStr);
                }
                BlackListFileLoader.overrideBlackList(blackPrefixList, overStr);
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        return blackPrefixList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readToList(InputStream input, String encoding, List<String> blackPrefixList) {
        block7: {
            InputStreamReader reader = null;
            BufferedReader bufferedReader = null;
            try {
                String lineText;
                reader = new InputStreamReader(input, encoding);
                bufferedReader = new BufferedReader(reader);
                while ((lineText = bufferedReader.readLine()) != null) {
                    String pkg = lineText.trim();
                    if (pkg.length() <= 0) continue;
                    blackPrefixList.add(pkg);
                }
                IOUtils.closeQuietly(bufferedReader);
            }
            catch (IOException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(e.getMessage(), e);
                }
                break block7;
            }
            finally {
                IOUtils.closeQuietly(bufferedReader);
                IOUtils.closeQuietly(reader);
            }
            IOUtils.closeQuietly(reader);
        }
    }

    static void overrideBlackList(List<String> originList, String overrideStr) {
        String[] overrideItems;
        ArrayList<String> adds = new ArrayList<String>();
        for (String overrideItem : overrideItems = StringUtils.splitWithCommaOrSemicolon(overrideStr)) {
            if (!StringUtils.isNotBlank(overrideItem)) continue;
            if (overrideItem.startsWith("!") || overrideItem.startsWith("-")) {
                if ("*".equals(overrideItem = overrideItem.substring(1)) || "default".equals(overrideItem)) {
                    originList.clear();
                    continue;
                }
                originList.remove(overrideItem);
                continue;
            }
            if (originList.contains(overrideItem)) continue;
            adds.add(overrideItem);
        }
        if (adds.size() > 0) {
            originList.addAll(adds);
        }
    }
}

