/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataFilter {
    private String oldBranchDb = null;
    private String filterInfo;
    private final StringBuilder builder;
    private final Map<String, Map<String, List<String>>> requires;

    public DataFilter() {
        this.filterInfo = null;
        this.builder = new StringBuilder();
        this.requires = new HashMap<String, Map<String, List<String>>>();
    }

    public DataFilter(String tableFields) {
        this.builder = new StringBuilder();
        this.requires = new HashMap<String, Map<String, List<String>>>();
        this.builder.append(tableFields);
    }

    public void setBranchDb(String db) {
        this.oldBranchDb = db;
    }

    public void addTablesFields(String tableFields) {
        this.builder.append(tableFields);
    }

    public List<String> getColNames(String db, String tb) {
        if (tb == null) {
            return null;
        }
        for (Map.Entry<String, Map<String, List<String>>> dbentry : this.requires.entrySet()) {
            StringBuffer buf = new StringBuffer(dbentry.getKey());
            int index = buf.indexOf("*");
            if (index != -1) {
                buf.insert(index, '.');
            }
            if (db != null && !db.toLowerCase().matches(buf.toString().toLowerCase())) continue;
            for (Map.Entry<String, List<String>> entry : dbentry.getValue().entrySet()) {
                buf = new StringBuffer(entry.getKey());
                index = buf.indexOf("*");
                if (index != -1) {
                    buf.insert(index, '.');
                }
                if (!tb.toLowerCase().matches(buf.toString().toLowerCase())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public void putColNames(String db, String tb, List<String> cols) {
        if (tb == null) {
            return;
        }
        boolean founded = false;
        for (Map.Entry<String, Map<String, List<String>>> dbentry : this.requires.entrySet()) {
            if (db != null && !db.equalsIgnoreCase(dbentry.getKey())) continue;
            for (Map.Entry<String, List<String>> entry : dbentry.getValue().entrySet()) {
                if (!tb.equalsIgnoreCase(entry.getKey())) continue;
                founded = true;
                entry.getValue().addAll(cols);
            }
            if (founded) continue;
            Map<String, List<String>> tabmap = dbentry.getValue();
            tabmap.put(tb, cols);
            founded = true;
        }
        if (!founded) {
            HashMap<String, List<String>> tabmap = new HashMap<String, List<String>>();
            tabmap.put(tb, cols);
            this.requires.put(db, tabmap);
        }
    }

    public boolean isColInArray(String col, List<String> s) {
        for (int i = 0; i < s.size(); ++i) {
            if (!s.get(i).equals("*") && !col.equalsIgnoreCase(s.get(i))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.filterInfo != null) {
            return this.filterInfo;
        }
        String s = this.builder.toString();
        String[] tbs = s.split("\\|");
        if (tbs == null) {
            return null;
        }
        int colStart = -1;
        StringBuilder builder1 = new StringBuilder();
        for (String s1 : tbs) {
            String itemTb;
            String itemDb;
            String[] tb = s1.split("[;,\\.]");
            if (tb == null || tb.length <= 0) continue;
            if (tb.length <= 2) {
                itemDb = this.oldBranchDb != null ? this.oldBranchDb : "*";
                colStart = 1;
                itemTb = tb[0];
            } else {
                colStart = 2;
                itemDb = tb[0];
                itemTb = tb[1];
            }
            builder1.append(itemDb).append(".").append(itemTb).append("|");
            if (colStart <= 0 || tb.length <= colStart) continue;
            ArrayList<String> cols = new ArrayList<String>();
            for (int i = colStart; i < tb.length; ++i) {
                cols.add(tb[i]);
            }
            this.putColNames(itemDb, itemTb, cols);
        }
        if (builder1.charAt(builder1.length() - 1) == '|') {
            builder1.deleteCharAt(builder1.length() - 1);
        }
        this.filterInfo = builder1.toString();
        return this.filterInfo;
    }
}

