/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message;

import java.io.UnsupportedEncodingException;

public class ByteString {
    private int len;
    private byte[] bytes;

    public ByteString(byte[] bytes, int len) {
        if (len == 0) {
            this.bytes = new byte[1];
            this.bytes[0] = 0;
            this.len = 0;
        } else {
            this.bytes = bytes;
            this.len = len;
        }
    }

    public ByteString(byte[] bytes, int offset, int len) {
        if (len == 0) {
            this.bytes = new byte[1];
            this.bytes[0] = 0;
            this.len = 0;
        } else {
            this.bytes = new byte[len];
            this.len = len;
            System.arraycopy(bytes, offset, this.bytes, 0, len);
        }
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        if (this.len == 0) {
            return new String("");
        }
        if (encoding.equalsIgnoreCase("binary")) {
            throw new UnsupportedEncodingException("field encoding: binary, use getBytes() instead of toString()");
        }
        String realEncoding = encoding;
        if (encoding.isEmpty() || encoding.equalsIgnoreCase("null")) {
            realEncoding = "ASCII";
        } else if (encoding.equalsIgnoreCase("utf8mb4")) {
            realEncoding = "utf8";
        } else if (encoding.equalsIgnoreCase("latin1")) {
            realEncoding = "cp1252";
        } else if (encoding.equalsIgnoreCase("latin2")) {
            realEncoding = "iso-8859-2 ";
        }
        return new String(this.bytes, realEncoding);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLen() {
        return this.len;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        ByteString byteString = (ByteString)o;
        if (byteString.len != this.len) {
            return false;
        }
        byte[] otherBytes = byteString.getBytes();
        for (int index = 0; index < this.len; ++index) {
            if (otherBytes[index] == this.bytes[index]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.len == 0) {
            return "";
        }
        int len = this.len;
        byte[] byteArray = this.bytes;
        char[] charArray = new char[len];
        for (int i = 0; i < len; ++i) {
            charArray[i] = (char)byteArray[i];
        }
        return String.valueOf(charArray);
    }
}

