/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openapiutil;

import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.utils.StringUtils;
import com.google.gson.Gson;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class Client {
    public static final String SEPARATOR = "&";
    public static final String URL_ENCODING = "UTF-8";
    public static final String ALGORITHM_NAME = "HmacSHA1";

    public static void convert(TeaModel body, TeaModel content) throws Exception {
        if (body == null || content == null) {
            return;
        }
        Class<?> bodyClass = body.getClass();
        Class<?> contentClass = content.getClass();
        Field[] fields = bodyClass.getDeclaredFields();
        TeaModel teaModel = (TeaModel)bodyClass.newInstance();
        for (Field field : fields) {
            field.setAccessible(true);
            if (InputStream.class.isAssignableFrom(field.getType())) continue;
            field.set(teaModel, field.get(body));
        }
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)teaModel);
        Object outPut = gson.fromJson(jsonString, contentClass);
        for (Field field : fields = outPut.getClass().getFields()) {
            field.setAccessible(true);
            field.set(content, field.get(outPut));
        }
    }

    public static String getStringToSign(TeaRequest request) throws Exception {
        String method = request.method;
        String pathname = request.pathname;
        Map headers = request.headers;
        Map query = request.query;
        String accept = headers.get("accept") == null ? "" : (String)headers.get("accept");
        String contentMD5 = headers.get("content-md5") == null ? "" : (String)headers.get("content-md5");
        String contentType = headers.get("content-type") == null ? "" : (String)headers.get("content-type");
        String date = headers.get("date") == null ? "" : (String)headers.get("date");
        String header = method + "\n" + accept + "\n" + contentMD5 + "\n" + contentType + "\n" + date + "\n";
        String canonicalizedHeaders = Client.getCanonicalizedHeaders(headers);
        String canonicalizedResource = Client.getCanonicalizedResource(pathname, query);
        String stringToSign = header + canonicalizedHeaders + canonicalizedResource;
        return stringToSign;
    }

    protected static String getCanonicalizedHeaders(Map<String, String> headers) {
        String prefix = "x-acs-";
        Set<String> keys = headers.keySet();
        ArrayList<String> canonicalizedKeys = new ArrayList<String>();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            canonicalizedKeys.add(key);
        }
        Object[] canonicalizedKeysArray = canonicalizedKeys.toArray(new String[canonicalizedKeys.size()]);
        Arrays.sort(canonicalizedKeysArray);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < canonicalizedKeysArray.length; ++i) {
            Object key = canonicalizedKeysArray[i];
            result.append((String)key);
            result.append(":");
            result.append(headers.get(key).trim());
            result.append("\n");
        }
        return result.toString();
    }

    protected static String getCanonicalizedResource(String pathname, Map<String, String> query) {
        Object[] keys = query.keySet().toArray(new String[query.size()]);
        if (keys.length <= 0) {
            return pathname;
        }
        Arrays.sort(keys);
        StringBuilder result = new StringBuilder(pathname);
        result.append("?");
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            result.append((String)key);
            String value = query.get(key);
            if (!StringUtils.isEmpty((CharSequence)value) && !"".equals(value.trim())) {
                result.append("=");
                result.append(value);
            }
            result.append(SEPARATOR);
        }
        return result.deleteCharAt(result.length() - 1).toString();
    }

    public static String getROASignature(String stringToSign, String secret) throws Exception {
        Mac mac = Mac.getInstance(ALGORITHM_NAME);
        mac.init(new SecretKeySpec(secret.getBytes(URL_ENCODING), ALGORITHM_NAME));
        byte[] signData = mac.doFinal(stringToSign.getBytes(URL_ENCODING));
        return Base64.getEncoder().encodeToString(signData);
    }

    public static String toForm(Map<String, ?> filter) throws Exception {
        return Client.toFormWithSymbol(filter, SEPARATOR);
    }

    private static String toFormWithSymbol(Map<String, ?> filter, String symbol) throws Exception {
        Map<String, String> map = Client.query(filter);
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtils.isEmpty((Object)entry.getValue())) continue;
            if (first) {
                first = false;
            } else {
                result.append(symbol);
            }
            result.append(URLEncoder.encode(entry.getKey(), URL_ENCODING));
            result.append("=");
            result.append(URLEncoder.encode(String.valueOf(entry.getValue()), URL_ENCODING));
        }
        return result.toString();
    }

    public static String getTimestamp() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return df.format(new Date());
    }

    public static Map<String, String> query(Map<String, ?> filter) throws Exception {
        HashMap<String, String> outMap = new HashMap<String, String>();
        if (null != filter) {
            Client.processeObject(outMap, "", filter);
        }
        return outMap;
    }

    private static void processeObject(Map<String, String> map, String key, Object value) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((Object)value)) {
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                Client.processeObject(map, key + "." + (i + 1), list.get(i));
            }
        } else if (value instanceof Map) {
            Map subMap = (Map)value;
            for (Map.Entry entry : subMap.entrySet()) {
                Client.processeObject(map, key + "." + (String)entry.getKey(), entry.getValue());
            }
        } else {
            if (key.startsWith(".")) {
                key = key.substring(1);
            }
            if (value instanceof byte[]) {
                map.put(key, new String((byte[])value, URL_ENCODING));
            } else {
                map.put(key, String.valueOf(value));
            }
        }
    }

    public static String getRPCSignature(Map<String, String> signedParams, String method, String secret) throws Exception {
        Map<String, String> queries = signedParams;
        Object[] sortedKeys = queries.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        StringBuilder canonicalizedQueryString = new StringBuilder();
        for (Object key : sortedKeys) {
            if (StringUtils.isEmpty((CharSequence)queries.get(key))) continue;
            canonicalizedQueryString.append(SEPARATOR).append(Client.percentEncode((String)key)).append("=").append(Client.percentEncode(queries.get(key)));
        }
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(method);
        stringToSign.append(SEPARATOR);
        stringToSign.append(Client.percentEncode("/"));
        stringToSign.append(SEPARATOR);
        stringToSign.append(Client.percentEncode(canonicalizedQueryString.toString().substring(1)));
        Mac mac = Mac.getInstance(ALGORITHM_NAME);
        mac.init(new SecretKeySpec((secret + SEPARATOR).getBytes(URL_ENCODING), ALGORITHM_NAME));
        byte[] signData = mac.doFinal(stringToSign.toString().getBytes(URL_ENCODING));
        return DatatypeConverter.printBase64Binary((byte[])signData);
    }

    public static String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, URL_ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    public static String arrayToStringWithSpecifiedStyle(Object array, String prefix, String style) throws Exception {
        if (null == array) {
            return "";
        }
        switch (style) {
            case "repeatList": {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(prefix, array);
                return Client.toFormWithSymbol(map, "&&");
            }
            case "simple": 
            case "spaceDelimited": 
            case "pipeDelimited": {
                return Client.flatArray((List)array, style);
            }
            case "json": {
                return new Gson().toJson(array);
            }
        }
        return "";
    }

    private static String flatArray(List array, String sty) {
        ArrayList<String> strs = new ArrayList<String>();
        for (int i = 0; i < array.size(); ++i) {
            strs.add(String.valueOf(array.get(i)));
        }
        if ("simple".equalsIgnoreCase(sty)) {
            return String.join((CharSequence)",", strs);
        }
        if ("spaceDelimited".equalsIgnoreCase(sty)) {
            return String.join((CharSequence)" ", strs);
        }
        return String.join((CharSequence)"|", strs);
    }
}

