/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.timeseries;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesKey;

public class GetTimeseriesDataRequest
implements Request {
    private final String timeseriesTableName;
    private TimeseriesKey timeseriesKey;
    private long beginTimeInUs;
    private long endTimeInUs;
    private int limit = -1;
    private byte[] nextToken;

    public GetTimeseriesDataRequest(String timeseriesTableName) {
        this.timeseriesTableName = timeseriesTableName;
    }

    public String getTimeseriesTableName() {
        return this.timeseriesTableName;
    }

    public TimeseriesKey getTimeseriesKey() {
        return this.timeseriesKey;
    }

    public void setTimeseriesKey(TimeseriesKey timeseriesKey) {
        this.timeseriesKey = timeseriesKey;
    }

    public void setTimeRange(long beginTimeInUs, long endTimeInUs) {
        Preconditions.checkArgument(beginTimeInUs >= 0L, "begin time must be large than or equal to 0");
        Preconditions.checkArgument(endTimeInUs > 0L, "end time must be large than 0");
        this.beginTimeInUs = beginTimeInUs;
        this.endTimeInUs = endTimeInUs;
    }

    public long getBeginTimeInUs() {
        return this.beginTimeInUs;
    }

    public long getEndTimeInUs() {
        return this.endTimeInUs;
    }

    public void setNextToken(byte[] nextToken) {
        this.nextToken = nextToken;
    }

    public byte[] getNextToken() {
        return this.nextToken;
    }

    @Override
    public String getOperationName() {
        return "GetTimeseriesData";
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        Preconditions.checkArgument(limit > 0, "limit must large than 0");
        this.limit = limit;
    }
}

