/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.tunnel.worker;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.tunnel.worker.IChannelProcessor;
import com.alicloud.openservices.tablestore.tunnel.worker.TunnelWorker;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelWorkerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TunnelWorker.class);
    private static final int CORE_POOL_SIZE = 32;
    private static final int KEEP_ALIVE_SECONDS = 60;
    private static final int MAX_CORE_POOL_SIZE = 1000;
    private static final int BLOCKING_QUEUE_SIZE = 16;
    private static final int HEARTBEAT_MIN_INTERVAL_SEC = 5;
    private static final int MAX_RETRY_MILL_SEC_MIN = 200;
    private long heartbeatTimeoutInSec = 300L;
    private long heartbeatIntervalInSec = 30L;
    private long checkpointIntervalInMillis = 5000L;
    private String clientTag = System.getProperty("os.name");
    private IChannelProcessor channelProcessor;
    private ThreadPoolExecutor readRecordsExecutor;
    private ThreadPoolExecutor processRecordsExecutor;
    private int maxChannelParallel = -1;
    private Semaphore maxChannelSemaphore;
    private ThreadPoolExecutor channelHelperExecutor;
    private int maxRetryIntervalInMillis = 2000;
    private int readMaxTimesPerRound = 1;
    private int readMaxBytesPerRound = 0x400000;
    private static final int READ_MAX_TIMES_PER_ROUND = 50;
    private static final int READ_MAX_BYTES_PER_ROUND = 0x4000000;

    public TunnelWorkerConfig() {
        this(TunnelWorkerConfig.newDefaultThreadPool("read-records-executor-"), TunnelWorkerConfig.newDefaultThreadPool("process-records-executor-"), null);
    }

    public TunnelWorkerConfig(IChannelProcessor processor) {
        this(TunnelWorkerConfig.newDefaultThreadPool("read-records-executor-"), TunnelWorkerConfig.newDefaultThreadPool("process-records-executor-"), processor);
    }

    public TunnelWorkerConfig(ThreadPoolExecutor readRecordsExecutor, ThreadPoolExecutor processRecordsExecutor, IChannelProcessor processor) {
        this.readRecordsExecutor = readRecordsExecutor;
        this.processRecordsExecutor = processRecordsExecutor;
        this.channelProcessor = processor;
    }

    public long getHeartbeatTimeoutInSec() {
        return this.heartbeatTimeoutInSec;
    }

    public void setHeartbeatTimeoutInSec(long heartbeatTimeoutInSec) {
        Preconditions.checkArgument(heartbeatTimeoutInSec > this.heartbeatIntervalInSec, "heartbeat timeout should larger than heartbeat interval.");
        this.heartbeatTimeoutInSec = heartbeatTimeoutInSec;
    }

    public long getHeartbeatIntervalInSec() {
        return this.heartbeatIntervalInSec;
    }

    public void setHeartbeatIntervalInSec(long heartbeatIntervalInSec) {
        Preconditions.checkArgument(heartbeatIntervalInSec >= 5L, "heartbeat interval must greater than or equal to %d seconds.", 5);
        this.heartbeatIntervalInSec = heartbeatIntervalInSec;
    }

    public String getClientTag() {
        return this.clientTag;
    }

    public void setClientTag(String clientTag) {
        this.clientTag = clientTag;
    }

    public IChannelProcessor getChannelProcessor() {
        return this.channelProcessor;
    }

    public void setChannelProcessor(IChannelProcessor channelProcessor) {
        this.channelProcessor = channelProcessor;
    }

    public long getCheckpointIntervalInMillis() {
        return this.checkpointIntervalInMillis;
    }

    public void setCheckpointIntervalInMillis(long checkpointIntervalInMillis) {
        this.checkpointIntervalInMillis = checkpointIntervalInMillis;
    }

    public ThreadPoolExecutor getReadRecordsExecutor() {
        return this.readRecordsExecutor;
    }

    public void setReadRecordsExecutor(ThreadPoolExecutor readRecordsExecutor) {
        if (this.readRecordsExecutor != null) {
            this.readRecordsExecutor.shutdownNow();
        }
        this.readRecordsExecutor = readRecordsExecutor;
    }

    public ThreadPoolExecutor getProcessRecordsExecutor() {
        return this.processRecordsExecutor;
    }

    public void setProcessRecordsExecutor(ThreadPoolExecutor processRecordsExecutor) {
        if (this.processRecordsExecutor != null) {
            this.processRecordsExecutor.shutdownNow();
        }
        this.processRecordsExecutor = processRecordsExecutor;
    }

    public int getMaxRetryIntervalInMillis() {
        return this.maxRetryIntervalInMillis;
    }

    public void setMaxRetryIntervalInMillis(int maxRetryIntervalInMillis) {
        Preconditions.checkArgument(maxRetryIntervalInMillis >= 200, "max retry interval must bigger than or equal to %s mill seconds.", 200);
        this.maxRetryIntervalInMillis = maxRetryIntervalInMillis;
    }

    public static ThreadPoolExecutor newDefaultThreadPool(final String threadPrefix) {
        return new ThreadPoolExecutor(32, 1000, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(16), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                String threadName = threadPrefix + this.counter.getAndIncrement();
                LOG.info("TunnelWorkerConfig new thread: " + threadName);
                return new Thread(r, threadName);
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public int getMaxChannelParallel() {
        return this.maxChannelParallel;
    }

    public void setMaxChannelParallel(int maxChannelParallel) {
        this.maxChannelParallel = maxChannelParallel;
    }

    void setMaxChannelSemaphore(Semaphore maxChannelSemaphore) {
        this.maxChannelSemaphore = maxChannelSemaphore;
    }

    Semaphore getMaxChannelSemaphore() {
        return this.maxChannelSemaphore;
    }

    public void setChannelHelperExecutor(ThreadPoolExecutor channelHelperExecutor) {
        this.channelHelperExecutor = channelHelperExecutor;
    }

    public ThreadPoolExecutor getChannelHelperExecutor() {
        return this.channelHelperExecutor;
    }

    public int getReadMaxTimesPerRound() {
        return this.readMaxTimesPerRound;
    }

    public void setReadMaxTimesPerRound(int readMaxTimesPerRound) {
        this.readMaxTimesPerRound = readMaxTimesPerRound;
    }

    public int getReadMaxBytesPerRound() {
        return this.readMaxBytesPerRound;
    }

    public void setReadMaxBytesPerRound(int readMaxBytesPerRound) {
        this.readMaxBytesPerRound = readMaxBytesPerRound;
    }

    public void shutdown() {
        LOG.info("shutdown read records executor");
        this.readRecordsExecutor.shutdownNow();
        try {
            if (this.readRecordsExecutor.awaitTermination(100L, TimeUnit.SECONDS)) {
                LOG.info("ReadRecords executor termination success.");
            } else {
                LOG.warn("ReadRecords executor termination until timeout");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Wait read records executor termination failed", (Throwable)e);
        }
        LOG.info("shutdown process records executor");
        this.processRecordsExecutor.shutdownNow();
        try {
            if (this.processRecordsExecutor.awaitTermination(100L, TimeUnit.SECONDS)) {
                LOG.info("ProcessRecords executor termination success.");
            } else {
                LOG.warn("ProcessRecords executor termination until timeout");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Wait process records executor termination failed", (Throwable)e);
        }
        if (this.channelHelperExecutor != null) {
            this.channelHelperExecutor.shutdownNow();
            LOG.info("shutdown channel helper executor");
        }
    }
}

