/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.groupby;

import com.alicloud.openservices.tablestore.core.protocol.SearchGroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupBy;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByType;
import com.alicloud.openservices.tablestore.model.search.sort.GroupBySorter;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GroupByField
implements GroupBy {
    private final GroupByType groupByType = GroupByType.GROUP_BY_FIELD;
    private String groupByName;
    private String fieldName;
    private Integer size;
    private List<GroupBySorter> groupBySorters;
    private List<Aggregation> subAggregations;
    private List<GroupBy> subGroupBys;
    private Long minDocCount;

    public GroupByField() {
    }

    private GroupByField(Builder builder) {
        this.groupByName = builder.groupByName;
        this.fieldName = builder.fieldName;
        this.size = builder.size;
        this.groupBySorters = builder.groupBySorters;
        this.subAggregations = builder.subAggregations;
        this.subGroupBys = builder.subGroupBys;
        this.minDocCount = builder.minDocCount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getGroupByName() {
        return this.groupByName;
    }

    @Override
    public GroupByType getGroupByType() {
        return this.groupByType;
    }

    @Override
    public ByteString serialize() {
        return SearchGroupByBuilder.buildGroupByField(this).toByteString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Long getMinDocCount() {
        return this.minDocCount;
    }

    public Integer getSize() {
        return this.size;
    }

    public List<GroupBySorter> getGroupBySorters() {
        return this.groupBySorters;
    }

    public List<Aggregation> getSubAggregations() {
        return this.subAggregations;
    }

    public List<GroupBy> getSubGroupBys() {
        return this.subGroupBys;
    }

    public GroupByField setGroupByName(String groupByName) {
        this.groupByName = groupByName;
        return this;
    }

    public GroupByField setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public GroupByField setMinDocCount(Long minDocCount) {
        this.minDocCount = minDocCount;
        return this;
    }

    public GroupByField setSize(Integer size) {
        this.size = size;
        return this;
    }

    public GroupByField setGroupBySorters(List<GroupBySorter> groupBySorters) {
        this.groupBySorters = groupBySorters;
        return this;
    }

    public GroupByField setSubAggregations(List<Aggregation> subAggregations) {
        this.subAggregations = subAggregations;
        return this;
    }

    public GroupByField setSubGroupBys(List<GroupBy> subGroupBys) {
        this.subGroupBys = subGroupBys;
        return this;
    }

    public static final class Builder
    implements GroupByBuilder {
        private String groupByName;
        private String fieldName;
        private Integer size;
        private List<GroupBySorter> groupBySorters;
        private List<Aggregation> subAggregations;
        private List<GroupBy> subGroupBys;
        private Long minDocCount;

        private Builder() {
        }

        public Builder groupByName(String groupByName) {
            this.groupByName = groupByName;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public Builder minDocCount(Long minDocCount) {
            this.minDocCount = minDocCount;
            return this;
        }

        public Builder addGroupBySorter(GroupBySorter ... groupBySorter) {
            if (this.groupBySorters == null) {
                this.groupBySorters = new ArrayList<GroupBySorter>();
            }
            this.groupBySorters.addAll(Arrays.asList(groupBySorter));
            return this;
        }

        public Builder addGroupBySorter(List<GroupBySorter> groupBySorter) {
            if (this.groupBySorters == null) {
                this.groupBySorters = new ArrayList<GroupBySorter>();
            }
            this.groupBySorters.addAll(groupBySorter);
            return this;
        }

        public Builder addSubAggregation(AggregationBuilder aggregationBuilder) {
            if (this.subAggregations == null) {
                this.subAggregations = new ArrayList<Aggregation>();
            }
            this.subAggregations.add(aggregationBuilder.build());
            return this;
        }

        public Builder addSubGroupBy(GroupByBuilder groupByBuilder) {
            if (this.subGroupBys == null) {
                this.subGroupBys = new ArrayList<GroupBy>();
            }
            this.subGroupBys.add(groupByBuilder.build());
            return this;
        }

        @Override
        public GroupByField build() {
            return new GroupByField(this);
        }
    }
}

