/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.com.fasterxml.jackson.databind.jsontype.impl;

import com.auth0.jwt.internal.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonParser;
import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonProcessingException;
import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonToken;
import com.auth0.jwt.internal.com.fasterxml.jackson.core.util.JsonParserSequence;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.BeanProperty;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.DeserializationContext;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JavaType;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JsonDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsWrapperTypeDeserializer
extends TypeDeserializerBase {
    public AsWrapperTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, Class<?> defaultImpl) {
        super(bt, idRes, typePropertyName, typeIdVisible, null);
    }

    protected AsWrapperTypeDeserializer(AsWrapperTypeDeserializer src, BeanProperty property) {
        super(src, property);
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        if (prop == this._property) {
            return this;
        }
        return new AsWrapperTypeDeserializer(this, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_OBJECT;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromScalar(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    private final Object _deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "need JSON Object to contain As.WRAPPER_OBJECT type information for class " + this.baseTypeName());
        }
        if (jp.nextToken() != JsonToken.FIELD_NAME) {
            throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "need JSON String that contains type id (for subtype of " + this.baseTypeName() + ")");
        }
        String typeId = jp.getText();
        JsonDeserializer<Object> deser = this._findDeserializer(ctxt, typeId);
        jp.nextToken();
        if (this._typeIdVisible && jp.getCurrentToken() == JsonToken.START_OBJECT) {
            TokenBuffer tb = new TokenBuffer(null);
            tb.writeStartObject();
            tb.writeFieldName(this._typePropertyName);
            tb.writeString(typeId);
            jp = JsonParserSequence.createFlattened(tb.asParser(jp), jp);
            jp.nextToken();
        }
        Object value = deser.deserialize(jp, ctxt);
        if (jp.nextToken() != JsonToken.END_OBJECT) {
            throw ctxt.wrongTokenException(jp, JsonToken.END_OBJECT, "expected closing END_OBJECT after type information and deserialized value");
        }
        return value;
    }
}

