/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.restful;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestfulServer {
    private static final Logger log = LoggerFactory.getLogger(RestfulServer.class);
    private final Server server;
    private final ServletContextHandler servletContextHandler;

    public RestfulServer(int port) {
        this.server = new Server(port);
        this.servletContextHandler = this.buildServletContextHandler();
    }

    public void start(String packages, Optional<String> resourcePath) throws Exception {
        this.start(packages, resourcePath, (Optional<String>)Optional.of((Object)"/api"));
    }

    public void start(String packages, Optional<String> resourcePath, Optional<String> servletPath) throws Exception {
        log.info("Elastic Job: Start RESTful server");
        HandlerList handlers = new HandlerList();
        if (resourcePath.isPresent()) {
            this.servletContextHandler.setBaseResource(Resource.newClassPathResource((String)((String)resourcePath.get())));
            this.servletContextHandler.addServlet(new ServletHolder(DefaultServlet.class), "/*");
        }
        String servletPathStr = (servletPath.isPresent() ? (String)servletPath.get() : "") + "/*";
        this.servletContextHandler.addServlet(this.getServletHolder(packages), servletPathStr);
        handlers.addHandler((Handler)this.servletContextHandler);
        this.server.setHandler((Handler)handlers);
        this.server.start();
    }

    public RestfulServer addFilter(Class<? extends Filter> filterClass, String urlPattern) {
        this.servletContextHandler.addFilter(filterClass, urlPattern, EnumSet.of(DispatcherType.REQUEST));
        return this;
    }

    private ServletContextHandler buildServletContextHandler() {
        ServletContextHandler result = new ServletContextHandler(1);
        result.setContextPath("/");
        return result;
    }

    private ServletHolder getServletHolder(String packages) {
        ServletHolder result = new ServletHolder(ServletContainer.class);
        result.setInitParameter("com.sun.jersey.config.property.packages", Joiner.on((String)",").join((Object)RestfulServer.class.getPackage().getName(), (Object)packages, new Object[0]));
        result.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", PackagesResourceConfig.class.getName());
        result.setInitParameter("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE.toString());
        result.setInitParameter("resteasy.scan.providers", Boolean.TRUE.toString());
        result.setInitParameter("resteasy.use.builtin.providers", Boolean.FALSE.toString());
        return result;
    }

    public void stop() {
        log.info("Elastic Job: Stop RESTful server");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            log.error("Elastic Job: Stop RESTful server error", (Throwable)e);
        }
    }
}

