/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.springboot;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.interceptor.SpringInterceptorFactory;
import com.dtflys.forest.listener.ConverterBeanListener;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.scanner.ClassPathClientScanner;
import com.dtflys.forest.schema.ForestConfigurationBeanDefinitionParser;
import com.dtflys.forest.springboot.annotation.ForestScannerRegister;
import com.dtflys.forest.springboot.properties.ForestConfigurationProperties;
import com.dtflys.forest.springboot.properties.ForestConvertProperties;
import com.dtflys.forest.springboot.properties.ForestConverterItemProperties;
import com.dtflys.forest.springboot.properties.ForestSSLKeyStoreProperties;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class ForestBeanRegister
implements ResourceLoaderAware,
BeanPostProcessor {
    private final ConfigurableApplicationContext applicationContext;
    private ResourceLoader resourceLoader;
    private ForestConfigurationProperties forestConfigurationProperties;

    public ForestBeanRegister(ConfigurableApplicationContext applicationContext, ForestConfigurationProperties forestConfigurationProperties) {
        this.applicationContext = applicationContext;
        this.forestConfigurationProperties = forestConfigurationProperties;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ForestConfiguration registerForestConfiguration(ForestConfigurationProperties forestConfigurationProperties) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ForestConfiguration.class);
        String id = forestConfigurationProperties.getBeanId();
        if (StringUtils.isBlank((String)id)) {
            id = "forestConfiguration";
        }
        Class<? extends ForestLogHandler> logHandlerClass = forestConfigurationProperties.getLogHandler();
        ForestLogHandler logHandler = null;
        if (logHandlerClass != null) {
            try {
                logHandler = logHandlerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ForestRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ForestRuntimeException((Throwable)e);
            }
        }
        beanDefinitionBuilder.addPropertyValue("maxConnections", (Object)forestConfigurationProperties.getMaxConnections()).addPropertyValue("maxRouteConnections", (Object)forestConfigurationProperties.getMaxRouteConnections()).addPropertyValue("timeout", (Object)forestConfigurationProperties.getTimeout()).addPropertyValue("connectTimeout", (Object)forestConfigurationProperties.getConnectTimeout()).addPropertyValue("charset", (Object)forestConfigurationProperties.getCharset()).addPropertyValue("retryer", (Object)forestConfigurationProperties.getRetryer()).addPropertyValue("retryCount", (Object)forestConfigurationProperties.getRetryCount()).addPropertyValue("maxRetryInterval", (Object)forestConfigurationProperties.getMaxRetryInterval()).addPropertyValue("logEnabled", (Object)forestConfigurationProperties.isLogEnabled()).addPropertyValue("logRequest", (Object)forestConfigurationProperties.isLogRequest()).addPropertyValue("logResponseStatus", (Object)forestConfigurationProperties.isLogResponseStatus()).addPropertyValue("logResponseContent", (Object)forestConfigurationProperties.isLogResponseContent()).addPropertyValue("logHandler", (Object)logHandler).addPropertyValue("backendName", (Object)forestConfigurationProperties.getBackend()).addPropertyValue("interceptors", forestConfigurationProperties.getInterceptors()).addPropertyValue("sslProtocol", (Object)forestConfigurationProperties.getSslProtocol()).addPropertyValue("variables", forestConfigurationProperties.getVariables()).setLazyInit(false).setFactoryMethod("configuration");
        BeanDefinition interceptorFactoryBeanDefinition = this.registerInterceptorFactoryBean();
        beanDefinitionBuilder.addPropertyValue("interceptorFactory", (Object)interceptorFactoryBeanDefinition);
        List<ForestSSLKeyStoreProperties> sslKeyStorePropertiesList = forestConfigurationProperties.getSslKeyStores();
        ManagedMap sslKeystoreMap = new ManagedMap();
        for (ForestSSLKeyStoreProperties keyStoreProperties : sslKeyStorePropertiesList) {
            this.registerSSLKeyStoreBean((ManagedMap<String, BeanDefinition>)sslKeystoreMap, keyStoreProperties);
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.getPropertyValues().addPropertyValue("sslKeyStores", (Object)sslKeystoreMap);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        ForestConfiguration configuration = (ForestConfiguration)this.applicationContext.getBean(id, ForestConfiguration.class);
        Map<String, Class> filters = forestConfigurationProperties.getFilters();
        for (Map.Entry<String, Class> entry : filters.entrySet()) {
            String filterName = entry.getKey();
            Class filterClass = entry.getValue();
            configuration.registerFilter(filterName, filterClass);
        }
        ForestConvertProperties convertProperties = forestConfigurationProperties.getConverters();
        if (convertProperties != null) {
            this.registerConverter(configuration, ForestDataType.TEXT, convertProperties.getText());
            this.registerConverter(configuration, ForestDataType.JSON, convertProperties.getJson());
            this.registerConverter(configuration, ForestDataType.XML, convertProperties.getXml());
            this.registerConverter(configuration, ForestDataType.BINARY, convertProperties.getBinary());
        }
        this.registerConverterBeanListener(configuration);
        return configuration;
    }

    public ConverterBeanListener registerConverterBeanListener(ForestConfiguration forestConfiguration) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConverterBeanListener.class);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.getPropertyValues().addPropertyValue("forestConfiguration", (Object)forestConfiguration);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition("forestConverterBeanListener", (BeanDefinition)beanDefinition);
        return (ConverterBeanListener)this.applicationContext.getBean("forestConverterBeanListener", ConverterBeanListener.class);
    }

    private void registerConverter(ForestConfiguration configuration, ForestDataType dataType, ForestConverterItemProperties converterItemProperties) {
        if (converterItemProperties == null) {
            return;
        }
        Class<? extends ForestJsonConverter> type = converterItemProperties.getType();
        if (type != null) {
            ForestConverter converter = null;
            try {
                PropertyDescriptor[] descriptors;
                converter = (ForestConverter)type.newInstance();
                Map<String, Object> parameters = converterItemProperties.getParameters();
                for (PropertyDescriptor descriptor : descriptors = ReflectUtils.getBeanSetters(type)) {
                    String name = descriptor.getName();
                    Object value = parameters.get(name);
                    Method method = descriptor.getWriteMethod();
                    if (method == null) continue;
                    try {
                        method.invoke((Object)converter, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new ForestRuntimeException("An error occurred during setting the property " + type.getName() + "." + name, (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ForestRuntimeException("An error occurred during setting the property " + type.getName() + "." + name, (Throwable)e);
                    }
                }
                configuration.getConverterMap().put(dataType, converter);
            }
            catch (InstantiationException e) {
                throw new ForestRuntimeException("[Forest] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ForestRuntimeException("[Forest] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
        }
    }

    public BeanDefinition registerInterceptorFactoryBean() {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpringInterceptorFactory.class);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition("forestInterceptorFactory", (BeanDefinition)beanDefinition);
        return beanDefinition;
    }

    public BeanDefinition registerSSLKeyStoreBean(ManagedMap<String, BeanDefinition> map, ForestSSLKeyStoreProperties sslKeyStoreProperties) {
        String id = sslKeyStoreProperties.getId();
        if (StringUtils.isBlank((String)id)) {
            throw new ForestRuntimeException("[Forest] Property 'id' of SSL keystore can not be empty or blank");
        }
        if (map.containsKey((Object)id)) {
            throw new ForestRuntimeException("[Forest] Duplicate SSL keystore id '" + id + "'");
        }
        BeanDefinition beanDefinition = ForestConfigurationBeanDefinitionParser.createSSLKeyStoreBean((String)id, (String)sslKeyStoreProperties.getType(), (String)sslKeyStoreProperties.getFile(), (String)sslKeyStoreProperties.getKeystorePass(), (String)sslKeyStoreProperties.getCertPass(), (String)sslKeyStoreProperties.getProtocols(), (String)sslKeyStoreProperties.getCipherSuites(), (String)sslKeyStoreProperties.getSslSocketFactoryBuilder());
        map.put((Object)id, (Object)beanDefinition);
        return beanDefinition;
    }

    public ClassPathClientScanner registerScanner(ForestConfigurationProperties forestConfigurationProperties) {
        List<String> basePackages = ForestScannerRegister.basePackages;
        String configurationId = ForestScannerRegister.configurationId;
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        ClassPathClientScanner scanner = new ClassPathClientScanner(configurationId, registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        if (basePackages == null || basePackages.size() == 0) {
            return scanner;
        }
        scanner.doScan(org.springframework.util.StringUtils.toStringArray(basePackages));
        return scanner;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.registerForestConfiguration(this.forestConfigurationProperties);
        this.registerScanner(this.forestConfigurationProperties);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

