package com.dtflys.forest.springboot;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ForestBeanListener implements BeanPostProcessor {

    private boolean inited = false;

    private final ForestBeanRegister forestBeanRegister;

    public ForestBeanListener(ForestBeanRegister forestBeanRegister) {
        this.forestBeanRegister = forestBeanRegister;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!inited) {
            forestBeanRegister.registerScanner();
            inited = true;
        }
        return BeanPostProcessor.super.postProcessAfterInitialization(bean, beanName);
    }

}
