/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.okhttps.Array;
import com.ejlchina.okhttps.ConvertProvider;
import com.ejlchina.okhttps.GsonArray;
import com.ejlchina.okhttps.GsonMapper;
import com.ejlchina.okhttps.Mapper;
import com.ejlchina.okhttps.MsgConvertor;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GsonMsgConvertor
implements MsgConvertor,
ConvertProvider {
    private Gson gson;

    public GsonMsgConvertor() {
        this(new Gson());
    }

    public GsonMsgConvertor(Gson gson) {
        this.gson = gson;
    }

    public String mediaType() {
        return "application/json";
    }

    public Mapper toMapper(InputStream in, Charset charset) {
        return new GsonMapper((JsonObject)this.gson.fromJson((Reader)new InputStreamReader(in), JsonObject.class));
    }

    public Array toArray(InputStream in, Charset charset) {
        return new GsonArray((JsonArray)this.gson.fromJson((Reader)new InputStreamReader(in), JsonArray.class));
    }

    public byte[] serialize(Object object, Charset charset) {
        return this.gson.toJson(object).getBytes(charset);
    }

    public <T> T toBean(Type type, InputStream in, Charset charset) {
        return (T)this.gson.fromJson((Reader)new InputStreamReader(in), type);
    }

    public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
        Object[] beans = (Object[])this.gson.fromJson((Reader)new InputStreamReader(in), TypeToken.getArray(type).getType());
        ArrayList list = new ArrayList();
        Collections.addAll(list, beans);
        return list;
    }

    public MsgConvertor getConvertor() {
        return new GsonMsgConvertor();
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }
}

