/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.internal;

import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.HttpTask;
import com.ejlchina.okhttps.MsgConvertor;
import com.ejlchina.okhttps.PingSupplier;
import com.ejlchina.okhttps.Platform;
import com.ejlchina.okhttps.TaskListener;
import com.ejlchina.okhttps.WebSocket;
import com.ejlchina.okhttps.internal.HttpClient;
import com.ejlchina.okhttps.internal.HttpException;
import com.ejlchina.okhttps.internal.RealHttpResult;
import com.ejlchina.okhttps.internal.TaskExecutor;
import com.ejlchina.okhttps.internal.WebSocketMsg;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocketListener;
import okhttp3.internal.ws.RealWebSocket;
import okio.ByteString;

public class WebSocketTask
extends HttpTask<WebSocketTask> {
    private WebSocket.Listener<HttpResult> onOpen;
    private WebSocket.Listener<Throwable> onException;
    private WebSocket.Listener<WebSocket.Message> onMessage;
    private WebSocket.Listener<WebSocket.Close> onClosing;
    private WebSocket.Listener<WebSocket.Close> onClosed;
    private boolean openOnIO;
    private boolean exceptionOnIO;
    private boolean messageOnIO;
    private boolean closingOnIO;
    private boolean closedOnIO;
    private int pingSeconds = -1;
    private int pongSeconds = -1;
    private long lastPingSecs = 0L;
    private long lastPongSecs = 0L;
    private PingSupplier pingSupplier;
    private WebSocketImpl webSocket;
    private boolean flexiblePing = true;

    public WebSocketTask(HttpClient httpClient, String url) {
        super(httpClient, url);
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    public WebSocketTask heatbeat(int pingSeconds, int pongSeconds) {
        if (pingSeconds < 0 || pongSeconds < 0) {
            throw new IllegalArgumentException("pingSeconds and pongSeconds must greater equal than 0!");
        }
        this.pingSeconds = pingSeconds;
        this.pongSeconds = pongSeconds;
        return this;
    }

    public WebSocketTask flexiblePing(boolean flexiblePing) {
        this.flexiblePing = flexiblePing;
        return this;
    }

    public WebSocketTask pingSupplier(PingSupplier pingSupplier) {
        this.pingSupplier = pingSupplier;
        return this;
    }

    public PingSupplier pingSupplier() {
        return this.pingSupplier;
    }

    public synchronized WebSocket listen() {
        if (this.webSocket != null) {
            return this.webSocket;
        }
        WebSocketImpl socket = new WebSocketImpl();
        this.registeTagTask(socket);
        this.httpClient.preprocess(this, () -> {
            WebSocketImpl webSocketImpl = socket;
            synchronized (webSocketImpl) {
                if (socket.cancelOrClosed) {
                    this.removeTagTask();
                } else {
                    Request request = this.prepareRequest("GET");
                    MessageListener listener = new MessageListener(socket);
                    this.httpClient.webSocket(request, listener);
                }
            }
        }, this.skipPreproc, this.skipSerialPreproc);
        this.webSocket = socket;
        return socket;
    }

    public boolean close(int code, String reason) {
        WebSocketImpl ws = this.webSocket;
        if (ws != null) {
            ws.close(code, reason);
            this.webSocket = null;
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        WebSocketImpl ws = this.webSocket;
        return ws != null && ws.status == 1;
    }

    private void schedulePing() {
        if (!this.isConnected()) {
            return;
        }
        int delay = (int)((long)this.pingSeconds + this.lastPingSecs - this.nowSeconds());
        this.httpClient.executor.requireScheduler().schedule(() -> {
            if (!this.isConnected()) {
                return;
            }
            WebSocketImpl ws = this.webSocket;
            if (this.nowSeconds() - this.lastPingSecs >= (long)this.pingSeconds && ws != null) {
                ByteString ping = this.pingSupplier != null ? this.pingSupplier.getPing() : ByteString.EMPTY;
                ws.send(ping);
                this.lastPingSecs = this.nowSeconds();
            }
            this.schedulePing();
        }, delay, TimeUnit.SECONDS);
    }

    private void schedulePong() {
        if (!this.isConnected()) {
            return;
        }
        int delay = (int)((long)this.pongSeconds + this.lastPongSecs - this.nowSeconds());
        this.httpClient.executor.requireScheduler().schedule(() -> {
            if (!this.isConnected()) {
                return;
            }
            long noPongSeconds = this.nowSeconds() - this.lastPongSecs;
            if (noPongSeconds > 3L * (long)this.pongSeconds) {
                WebSocketImpl ws = this.webSocket;
                if (ws != null) {
                    SocketTimeoutException e = new SocketTimeoutException("Server didn't pong heart-beat on time. Last received at " + noPongSeconds + " seconds ago.");
                    ((RealWebSocket)ws.webSocket).failWebSocket((Exception)e, null);
                }
            } else {
                this.schedulePong();
            }
        }, delay, TimeUnit.SECONDS);
    }

    private long nowSeconds() {
        return System.nanoTime() / 1000000000L;
    }

    public WebSocketTask setOnOpen(WebSocket.Listener<HttpResult> onOpen) {
        this.onOpen = onOpen;
        this.openOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public WebSocketTask setOnException(WebSocket.Listener<Throwable> onException) {
        this.onException = onException;
        this.exceptionOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public WebSocketTask setOnMessage(WebSocket.Listener<WebSocket.Message> onMessage) {
        this.onMessage = onMessage;
        this.messageOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public WebSocketTask setOnClosing(WebSocket.Listener<WebSocket.Close> onClosing) {
        this.onClosing = onClosing;
        this.closingOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public WebSocketTask setOnClosed(WebSocket.Listener<WebSocket.Close> onClosed) {
        this.onClosed = onClosed;
        this.closedOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public int pingSeconds() {
        return this.pingSeconds;
    }

    public int pongSeconds() {
        return this.pongSeconds;
    }

    class WebSocketImpl
    implements WebSocket {
        private boolean cancelOrClosed;
        private okhttp3.WebSocket webSocket;
        private final List<Object> queues = new ArrayList<Object>();
        private Charset charset;
        private String msgType;
        private int status = 2;

        public WebSocketImpl() {
            String bodyType = WebSocketTask.this.getBodyType();
            this.msgType = "form".equalsIgnoreCase(bodyType) ? "json" : bodyType;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        @Override
        public synchronized boolean cancel() {
            if (this.webSocket != null) {
                this.webSocket.cancel();
            }
            this.cancelOrClosed = true;
            return true;
        }

        @Override
        public synchronized void close(int code, String reason) {
            if (this.webSocket != null) {
                this.webSocket.close(code, reason);
            }
            this.cancelOrClosed = true;
        }

        @Override
        public void msgType(String type) {
            if (type == null || type.equalsIgnoreCase("form")) {
                throw new IllegalArgumentException("msgType \u4e0d\u53ef\u4e3a\u7a7a \u6216 form");
            }
            this.msgType = type.toLowerCase();
        }

        @Override
        public int status() {
            return this.status;
        }

        @Override
        public long queueSize() {
            if (this.webSocket != null) {
                return this.webSocket.queueSize();
            }
            return this.queues.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean send(Object msg) {
            if (msg == null) {
                return false;
            }
            List<Object> list = this.queues;
            synchronized (list) {
                if (this.webSocket != null) {
                    return this.send(this.webSocket, msg);
                }
                this.queues.add(msg);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setWebSocket(okhttp3.WebSocket webSocket) {
            List<Object> list = this.queues;
            synchronized (list) {
                for (Object msg : this.queues) {
                    this.send(webSocket, msg);
                }
                this.webSocket = webSocket;
                this.queues.clear();
            }
        }

        public void setStatus(int status) {
            this.status = status;
        }

        boolean send(okhttp3.WebSocket webSocket, Object msg) {
            if (msg == null) {
                return false;
            }
            if (WebSocketTask.this.pingSeconds > 0 && WebSocketTask.this.flexiblePing) {
                WebSocketTask.this.lastPingSecs = WebSocketTask.this.nowSeconds();
            }
            if (msg instanceof String) {
                return webSocket.send((String)msg);
            }
            if (msg instanceof ByteString) {
                return webSocket.send((ByteString)msg);
            }
            if (msg instanceof byte[]) {
                return webSocket.send(ByteString.of((byte[])((byte[])msg)));
            }
            byte[] bytes = (byte[])((WebSocketTask)WebSocketTask.this).httpClient.executor.doMsgConvert((String)this.msgType, (TaskExecutor.ConvertFunc<byte[]>)LambdaMetafactory.metafactory(null, null, null, (Lcom/ejlchina/okhttps/MsgConvertor;)Ljava/lang/Object;, lambda$send$0(java.lang.Object com.ejlchina.okhttps.MsgConvertor ), (Lcom/ejlchina/okhttps/MsgConvertor;)[B)((WebSocketImpl)this, (Object)msg)).data;
            return webSocket.send(new String(bytes, this.charset));
        }

        private /* synthetic */ byte[] lambda$send$0(Object msg, MsgConvertor c) {
            return c.serialize(msg, this.charset);
        }
    }

    class MessageListener
    extends WebSocketListener {
        final WebSocketImpl webSocket;
        Charset charset;

        public MessageListener(WebSocketImpl webSocket) {
            this.webSocket = webSocket;
        }

        public void onOpen(okhttp3.WebSocket webSocket, Response response) {
            this.charset = WebSocketTask.this.charset(response);
            this.webSocket.setCharset(this.charset);
            this.webSocket.setWebSocket(webSocket);
            this.webSocket.setStatus(1);
            TaskListener<HttpResult> listener = ((WebSocketTask)WebSocketTask.this).httpClient.executor.getResponseListener();
            RealHttpResult result = new RealHttpResult(WebSocketTask.this, response, ((WebSocketTask)WebSocketTask.this).httpClient.executor);
            WebSocket.Listener openListener = WebSocketTask.this.onOpen;
            if (listener != null) {
                if (listener.listen(WebSocketTask.this, result) && openListener != null) {
                    WebSocketTask.this.execute(() -> openListener.on(this.webSocket, result), WebSocketTask.this.openOnIO);
                }
            } else if (openListener != null) {
                WebSocketTask.this.execute(() -> openListener.on(this.webSocket, result), WebSocketTask.this.openOnIO);
            }
            if (WebSocketTask.this.pingSeconds > 0) {
                WebSocketTask.this.lastPingSecs = WebSocketTask.this.nowSeconds();
                WebSocketTask.this.schedulePing();
            }
            if (WebSocketTask.this.pongSeconds > 0) {
                WebSocketTask.this.lastPongSecs = WebSocketTask.this.nowSeconds();
                WebSocketTask.this.schedulePong();
            }
        }

        public void onMessage(okhttp3.WebSocket webSocket, String text) {
            WebSocket.Listener listener = WebSocketTask.this.onMessage;
            if (listener != null) {
                WebSocketTask.this.execute(() -> listener.on(this.webSocket, new WebSocketMsg(text, ((WebSocketTask)WebSocketTask.this).httpClient.executor, this.charset)), WebSocketTask.this.messageOnIO);
            }
            if (WebSocketTask.this.pongSeconds > 0) {
                WebSocketTask.this.lastPongSecs = WebSocketTask.this.nowSeconds();
                Platform.logInfo("PONG <<< " + text);
            }
        }

        public void onMessage(okhttp3.WebSocket webSocket, ByteString bytes) {
            WebSocket.Listener listener = WebSocketTask.this.onMessage;
            if (listener != null) {
                WebSocketTask.this.execute(() -> listener.on(this.webSocket, new WebSocketMsg(bytes, ((WebSocketTask)WebSocketTask.this).httpClient.executor, this.charset)), WebSocketTask.this.messageOnIO);
            }
            if (WebSocketTask.this.pongSeconds > 0) {
                WebSocketTask.this.lastPongSecs = WebSocketTask.this.nowSeconds();
                Platform.logInfo("PONG <<< " + bytes.utf8());
            }
        }

        public void onClosing(okhttp3.WebSocket webSocket, int code, String reason) {
            this.webSocket.setStatus(3);
            WebSocket.Listener listener = WebSocketTask.this.onClosing;
            if (listener != null) {
                WebSocketTask.this.execute(() -> listener.on(this.webSocket, new WebSocket.Close(code, reason)), WebSocketTask.this.closingOnIO);
            }
        }

        public void onClosed(okhttp3.WebSocket webSocket, int code, String reason) {
            this.doOnClose(HttpResult.State.RESPONSED, code, reason);
        }

        private void doOnClose(HttpResult.State state, int code, String reason) {
            WebSocketTask.this.webSocket = null;
            WebSocket.Close close = this.updateStatus(state, code, reason);
            TaskListener<HttpResult.State> listener = ((WebSocketTask)WebSocketTask.this).httpClient.executor.getCompleteListener();
            WebSocket.Listener closeListener = WebSocketTask.this.onClosed;
            if (listener != null) {
                if (listener.listen(WebSocketTask.this, state) && closeListener != null) {
                    WebSocketTask.this.execute(() -> closeListener.on(this.webSocket, close), WebSocketTask.this.closedOnIO);
                }
            } else if (closeListener != null) {
                WebSocketTask.this.execute(() -> closeListener.on(this.webSocket, close), WebSocketTask.this.closedOnIO);
            }
        }

        private WebSocket.Close updateStatus(HttpResult.State state, int code, String reason) {
            if (state == HttpResult.State.CANCELED) {
                this.webSocket.setStatus(0);
                return new WebSocket.Close(WebSocket.Close.CANCELED, "Canceled");
            }
            if (state == HttpResult.State.EXCEPTION) {
                this.webSocket.setStatus(-1);
                return new WebSocket.Close(WebSocket.Close.CANCELED, reason);
            }
            if (state == HttpResult.State.NETWORK_ERROR) {
                this.webSocket.setStatus(-2);
                return new WebSocket.Close(WebSocket.Close.NETWORK_ERROR, reason);
            }
            if (state == HttpResult.State.TIMEOUT) {
                this.webSocket.setStatus(-3);
                return new WebSocket.Close(WebSocket.Close.TIMEOUT, reason);
            }
            this.webSocket.setStatus(3);
            return new WebSocket.Close(code, reason);
        }

        public void onFailure(okhttp3.WebSocket webSocket, Throwable t, Response response) {
            IOException e = t instanceof IOException ? (IOException)t : new IOException(t.getMessage(), t);
            this.doOnClose(WebSocketTask.this.toState(e), 0, t.getMessage());
            TaskListener<IOException> listener = ((WebSocketTask)WebSocketTask.this).httpClient.executor.getExceptionListener();
            WebSocket.Listener exceptionListener = WebSocketTask.this.onException;
            if (listener != null) {
                if (listener.listen(WebSocketTask.this, e) && exceptionListener != null) {
                    WebSocketTask.this.execute(() -> exceptionListener.on(this.webSocket, t), WebSocketTask.this.exceptionOnIO);
                }
            } else if (exceptionListener != null) {
                WebSocketTask.this.execute(() -> exceptionListener.on(this.webSocket, t), WebSocketTask.this.exceptionOnIO);
            } else if (!WebSocketTask.this.nothrow) {
                throw new HttpException("WebSockt \u8fde\u63a5\u5f02\u5e38: " + WebSocketTask.this.getUrl(), t);
            }
        }
    }
}

