/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.common.constant.response;

import com.envisioniot.enos.api.common.constant.response.IErrorResponseInfo;
import com.envisioniot.enos.api.common.constant.response.error.constant.EnosErrorCode;
import java.io.Serializable;

public class AbstractEnosRsp<T>
implements Serializable {
    public static final String DEFAULT_SUCCESS_MSG = "OK";
    private static final long serialVersionUID = 1631581822673922031L;
    private int code = 0;
    private String msg;
    private String requestId;
    private T data;

    public AbstractEnosRsp() {
    }

    public AbstractEnosRsp(int code, String msg, String requestId, T data) {
        this.code = code;
        this.msg = msg;
        this.requestId = requestId;
        this.data = data;
    }

    public boolean success() {
        return this.code == 0;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "AbstractEnosRsp(code=" + this.getCode() + ", msg=" + this.getMsg() + ", requestId=" + this.getRequestId() + ", data=" + this.getData() + ")";
    }

    public static abstract class AbstractBuilder<T> {
        private int code;
        private String msg;
        private T data;
        private String requestId;

        public AbstractBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public AbstractBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public AbstractBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public AbstractBuilder<T> wrapSuccess() {
            return this.msg(EnosErrorCode.SUCCESS.getMsg(new String[0])).code(EnosErrorCode.SUCCESS.getCode());
        }

        public AbstractBuilder<T> wrapFailed(IErrorResponseInfo error) {
            return this.code(error.getCode()).msg(error.getMsg());
        }

        public AbstractBuilder<T> wrapFailed(int code, String msg) {
            return this.code(code).msg(msg);
        }

        public AbstractBuilder<T> wrapFailed(IErrorResponseInfo error, String extMsg) {
            return this.code(error.getCode()).msg(error.getMsg() + ": " + extMsg);
        }

        protected abstract <E extends AbstractEnosRsp<T>> E createRspInstance();

        public <E extends AbstractEnosRsp<T>> E build() {
            E ret;
            E rsp = ret = this.createRspInstance();
            ((AbstractEnosRsp)rsp).data = this.data;
            ((AbstractEnosRsp)rsp).code = this.code;
            ((AbstractEnosRsp)rsp).msg = this.msg;
            ((AbstractEnosRsp)rsp).requestId = this.requestId;
            return ret;
        }
    }
}

