/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.common.constant.response;

import com.envisioniot.enos.api.common.constant.request.Sorter;
import com.envisioniot.enos.api.common.constant.response.EnosSortedData;
import java.util.List;

public class EnosScrollData<T>
extends EnosSortedData<T> {
    private static final long serialVersionUID = -589032144526201462L;
    private String pageToken;
    private int pageSize;

    public EnosScrollData() {
    }

    public EnosScrollData(List<Sorter> sortedBy, String pageToken, int pageSize, List<T> items) {
        super(sortedBy, items);
        this.pageToken = pageToken;
        this.pageSize = pageSize;
    }

    public static <T> EnosScrollDataBuilder<T> builder() {
        return new EnosScrollDataBuilder();
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return "EnosScrollData(pageToken=" + this.getPageToken() + ", pageSize=" + this.getPageSize() + ")";
    }

    public static class EnosScrollDataBuilder<T> {
        private int pageSize;
        private List<Sorter> sortedBy;
        private String pageToken;
        private List<T> items;

        EnosScrollDataBuilder() {
        }

        public EnosScrollDataBuilder<T> pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public EnosScrollDataBuilder<T> sortedBy(List<Sorter> sortedBy) {
            this.sortedBy = sortedBy;
            return this;
        }

        public EnosScrollDataBuilder<T> pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public EnosScrollDataBuilder<T> items(List<T> items) {
            this.items = items;
            return this;
        }

        public EnosScrollData<T> build() {
            return new EnosScrollData<T>(this.sortedBy, this.pageToken, this.pageSize, this.items);
        }

        public String toString() {
            return "EnosScrollData.EnosScrollDataBuilder(pageSize=" + this.pageSize + ", sortedBy=" + this.sortedBy + ", pageToken=" + this.pageToken + ", items=" + this.items + ")";
        }
    }
}

