/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.common.constant.response.error.constant;

public class EnosErrorCode {
    public static int PREDEFINED = 0;
    public static int USERDEFINED = 1;
    public static final EnosErrorCode SUCCESS = new EnosErrorCode(0, "OK", PREDEFINED);
    public static final EnosErrorCode BATCH_PARTIAL_CONTENT_SUCCESS = new EnosErrorCode(206, "Partial Content Success", PREDEFINED);
    public static final EnosErrorCode INVALID_ARGUMENT = new EnosErrorCode(400, "Invalid Argument ${param}", PREDEFINED);
    public static final EnosErrorCode UNAUTHENTICATED = new EnosErrorCode(401, "Unauthenticated", PREDEFINED);
    public static final EnosErrorCode PERMISSION_DENIED = new EnosErrorCode(403, "Permission Denied", PREDEFINED);
    public static final EnosErrorCode NOT_FOUND = new EnosErrorCode(404, "Not Found", PREDEFINED);
    public static final EnosErrorCode METHOD_NOT_ALLOWED = new EnosErrorCode(405, "Method Not Allowed", PREDEFINED);
    public static final EnosErrorCode ALREADY_EXISTS = new EnosErrorCode(409, "Already Exists", PREDEFINED);
    public static final EnosErrorCode REQUEST_BODY_TOO_LARGE = new EnosErrorCode(413, "Request Body Too Large", PREDEFINED);
    public static final EnosErrorCode PARAMETER_OUT_OF_RANGE = new EnosErrorCode(415, "Parameter Out Of Range", PREDEFINED);
    public static final EnosErrorCode RESOURCE_EXHAUSTED = new EnosErrorCode(429, "Resource Exhausted", PREDEFINED);
    public static final EnosErrorCode RESULT_SIZE_TOO_LARGE = new EnosErrorCode(430, "Result size too large", PREDEFINED);
    public static final EnosErrorCode APP_TIMESTAMP_FAIL = new EnosErrorCode(497, "App Timestamp Checked Fail", PREDEFINED);
    public static final EnosErrorCode APP_SIGN_FAIL = new EnosErrorCode(497, "App Signature Checked Fail", PREDEFINED);
    public static final EnosErrorCode APP_RESOURCE_FAIL = new EnosErrorCode(498, "App Resource Permission Denied", PREDEFINED);
    public static final EnosErrorCode APP_API_FAIL = new EnosErrorCode(498, "App Api Permission Denied", PREDEFINED);
    public static final EnosErrorCode CLIENT_ERROR = new EnosErrorCode(499, "Client Error", PREDEFINED);
    public static final EnosErrorCode INTERNAL_SERVER_ERROR = new EnosErrorCode(500, "Internal Server Error", PREDEFINED);
    public static final EnosErrorCode NOT_IMPLEMENTED = new EnosErrorCode(501, "Not Implemented", PREDEFINED);
    public static final EnosErrorCode SERVICE_UNAVAILABLE = new EnosErrorCode(503, "Service Unavailable", PREDEFINED);
    public static final EnosErrorCode SERVICE_TIMEOUT = new EnosErrorCode(504, "Service Timeout", PREDEFINED);
    public static final EnosErrorCode UNSUPPORTED_OPERATION = new EnosErrorCode(601, "Unsupported Operation for Particular Resource", PREDEFINED);
    public static int MAX_CODE_FOR_PREDEFINED = 599;
    public static final EnosErrorCode DATA_SERVICE_ERROR = new EnosErrorCode(701, "data service ERROR.", USERDEFINED);
    public static final EnosErrorCode DATA_SERVICE_EXEC_ERROR = new EnosErrorCode(702, "An error occurred when execute query in data service.", USERDEFINED);
    private int code;
    private String msg;
    private int type;

    private EnosErrorCode(int code, String msg, int type) {
        this.code = code;
        this.msg = msg;
        this.type = type;
    }

    public EnosErrorCode(int code, String msg) {
        this(code, msg, USERDEFINED);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg(String ... reps) {
        String msg = this.msg;
        if (msg == null) {
            msg = "";
        }
        for (String rep : reps) {
            msg = msg.replaceAll("\\$\\{[^\\}]*\\}", rep);
        }
        return msg.replaceAll("\\$\\{([^\\}]*)\\}", "$1");
    }

    public void setMsg(String msg, String ... reps) {
        if (msg == null || msg.equals("")) {
            msg = this.msg;
        }
        for (String rep : reps) {
            msg = msg.replaceAll("\\$\\{[^\\}]*\\}", rep);
        }
        this.msg = msg;
    }

    public EnosErrorCode replaceMsg(String msg, String ... reps) {
        EnosErrorCode newCode = new EnosErrorCode(this.code, this.msg, this.type);
        if (msg == null || msg.equals("")) {
            msg = newCode.msg;
        }
        for (String rep : reps) {
            msg = msg.replaceFirst("\\$\\{[^\\}]*\\}", rep);
        }
        newCode.msg = msg;
        return newCode;
    }

    public EnosErrorCode addMsg(String msg, String ... reps) {
        EnosErrorCode newCode = new EnosErrorCode(this.code, this.msg, this.type);
        msg = msg == null || msg.equals("") ? newCode.msg : newCode.msg + ":" + msg;
        for (String rep : reps) {
            msg = msg.replaceFirst("\\$\\{[^\\}]*\\}", rep);
        }
        newCode.msg = msg;
        return newCode;
    }

    public EnosErrorCode paramMissing(String paramName) {
        String newMsg = this.msg.replaceAll("\\$\\{[^\\}]*\\}", paramName) + ":" + paramName + " is missing";
        return new EnosErrorCode(this.code, newMsg, this.type);
    }

    public EnosErrorCode customMsg(String customMsg) {
        return new EnosErrorCode(this.code, customMsg, this.type);
    }
}

