/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr;

import com.envisioniot.enos.api.framework.expr.ExpressionBaseVisitor;
import com.envisioniot.enos.api.framework.expr.IFQLExpression;
import com.envisioniot.enos.api.framework.expr.constant.FQLBooleanValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLDoubleValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLListValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLLocalTimeValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLLongValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLStringValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLUTCTimeValue;
import com.envisioniot.enos.api.framework.expr.expression.FQLInExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLIsNullExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLLikeExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLLogicalExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLLogicalListExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLMathExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLRLikeExpression;
import com.envisioniot.enos.api.framework.expr.expression.FQLUnaryExpr;
import com.envisioniot.enos.api.framework.expr.expression.FqlExistExpr;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;

@Deprecated
public class ExpressionFqlStringVisitor
extends ExpressionBaseVisitor<String> {
    public static String parse(IFQLExpression expression) {
        ExpressionFqlStringVisitor visitor = new ExpressionFqlStringVisitor();
        String result = visitor.visitIFQLExpression(expression);
        result = result.length() >= 2 && result.charAt(0) == '(' && result.charAt(result.length() - 1) == ')' ? result.substring(1, result.length() - 1) : result;
        return result;
    }

    @Override
    public String visitIFQLExpression(IFQLExpression expression) {
        return (String)super.visitIFQLExpression(expression);
    }

    @Override
    public String visitInExpression(FQLInExpr expression) {
        String key = expression.getField();
        String values = this.visitIFQLExpression(expression.getValues());
        return key + " in " + values;
    }

    @Override
    public String visitFQLIsNullExpr(FQLIsNullExpr expression) {
        String key = expression.getField();
        boolean isNull = expression.getIsNull();
        return isNull ? key + " is null" : key + " is not null";
    }

    @Override
    public String visitFQLLikeExpr(FQLLikeExpr expression) {
        String key = expression.getField();
        String value = "'" + expression.getValue() + "'";
        return key + " like " + value;
    }

    @Override
    public String visitFQLExistExpr(FqlExistExpr expression) {
        String key = expression.getField();
        return "exists ( " + key + " )";
    }

    @Override
    public String visitFQLLogicalExpr(FQLLogicalExpr expression) {
        String leftExpr = this.visitIFQLExpression(expression.getLeftExpr());
        String rightExpr = this.visitIFQLExpression(expression.getRightExpr());
        StringBuilder sb = new StringBuilder();
        if (leftExpr != null && leftExpr.length() > 0) {
            sb.append(leftExpr + " " + expression.getExprOPStr() + " ");
        }
        if (rightExpr != null && rightExpr.length() > 0) {
            sb.append(rightExpr + " " + expression.getExprOPStr() + " ");
        }
        return sb.length() > 0 ? "(" + sb.substring(0, sb.length() - expression.getExprOPStr().length() - 2) + ")" : "";
    }

    @Override
    public String visitFQLLogicalListExpr(FQLLogicalListExpr expression) {
        String op = expression.getOp();
        StringBuffer sb = new StringBuffer();
        expression.getList().forEach(expr -> {
            sb.append(this.visitIFQLExpression((IFQLExpression)expr) + " ");
            sb.append(op + " ");
        });
        return sb.length() > 0 ? "(" + sb.substring(0, sb.length() - op.length() - 2) + ")" : "";
    }

    @Override
    public String visitFQLMathExpr(FQLMathExpr expression) {
        String key = expression.getField();
        String op = expression.getOp().getLiteral();
        String value = this.visitIFQLExpression(expression.getValue());
        return key + " " + op + " " + value;
    }

    @Override
    public String visitFQLRLikeExpression(FQLRLikeExpression expression) {
        String key = expression.getField();
        String value = "'" + expression.getValue() + "'";
        return key + " rlike " + value;
    }

    @Override
    public String visitFQLUnaryExpr(FQLUnaryExpr expression) {
        String op = expression.getOp();
        StringBuffer sb = new StringBuffer();
        sb.append(op + " ");
        sb.append(this.visitIFQLExpression(expression.getExpr()));
        return sb.toString();
    }

    @Override
    public String visitFQLLongValue(FQLLongValue expression) {
        return String.valueOf(expression.getValue());
    }

    @Override
    public String visitFQLBooleanValue(FQLBooleanValue expression) {
        return String.valueOf(expression.getValue());
    }

    @Override
    public String visitFQLDoubleValue(FQLDoubleValue expression) {
        return String.valueOf(expression.getValue());
    }

    @Override
    public String visitFQLListValue(FQLListValue expression) {
        List values = expression.getList().stream().map(expr -> this.visitIFQLExpression((IFQLExpression)expr)).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder(values.toString());
        sb.replace(0, 1, "(");
        sb.replace(sb.length() - 1, sb.length(), ")");
        return sb.toString();
    }

    @Override
    public String visitFQLLocalTimeValue(FQLLocalTimeValue expression) {
        return expression.getLocalTime();
    }

    @Override
    public String visitFQLStringValue(FQLStringValue expression) {
        return "'" + expression.getValue() + "'";
    }

    @Override
    public String visitFQLUTCTimeValue(FQLUTCTimeValue expression) {
        return "'" + ExpressionFqlStringVisitor.toUTC(expression.getTimestamp()) + "'";
    }

    public static String toUTC(long time) {
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }
}

