/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr;

import com.envisioniot.enos.api.framework.expr.FQLErrorListener;
import com.envisioniot.enos.api.framework.expr.IFQLExpression;
import com.envisioniot.enos.api.framework.expr.antlrgen.FQLBaseVisitor;
import com.envisioniot.enos.api.framework.expr.antlrgen.FQLLexer;
import com.envisioniot.enos.api.framework.expr.antlrgen.FQLParser;
import com.envisioniot.enos.api.framework.expr.constant.FQLBooleanValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLDoubleValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLKeyWord;
import com.envisioniot.enos.api.framework.expr.constant.FQLListValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLLocalTimeValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLLongValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLStringValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLUTCTimeValue;
import com.envisioniot.enos.api.framework.expr.exception.FQLGrammarException;
import com.envisioniot.enos.api.framework.expr.expression.FQLInExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLIsNullExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLLikeExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLLogicalExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLMathExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLRLikeExpression;
import com.envisioniot.enos.api.framework.expr.expression.FQLUnaryExpr;
import com.envisioniot.enos.api.framework.expr.expression.FqlExistExpr;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

@Deprecated
public class FQLConvertVistor
extends FQLBaseVisitor<IFQLExpression> {
    private static final String DATEFORMATE = "yyyy-MM-dd HH:mm:ss";

    @Deprecated
    public static IFQLExpression parse(String FQL) {
        ByteArrayInputStream is = new ByteArrayInputStream(FQL.getBytes());
        CommonTokenStream tokens = null;
        FQLLexer lexer = null;
        try {
            lexer = new FQLLexer(CharStreams.fromStream((InputStream)is));
        }
        catch (Exception e) {
            throw new FQLGrammarException(e.getMessage());
        }
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new FQLErrorListener());
        tokens = new CommonTokenStream((TokenSource)lexer);
        ErrorReportParser parser = new ErrorReportParser((TokenStream)tokens);
        FQLParser.FqlContext tree = parser.fql();
        FQLConvertVistor visitor = new FQLConvertVistor();
        return (IFQLExpression)visitor.visit((ParseTree)tree);
    }

    @Override
    public IFQLExpression visitFql(FQLParser.FqlContext ctx) {
        return (IFQLExpression)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public IFQLExpression visitOneExpression(FQLParser.OneExpressionContext ctx) {
        return (IFQLExpression)super.visitOneExpression(ctx);
    }

    @Override
    public IFQLExpression visitMoreAndExpression(FQLParser.MoreAndExpressionContext ctx) {
        return (IFQLExpression)super.visitMoreAndExpression(ctx);
    }

    @Override
    public IFQLExpression visitOne_or_and_expression(FQLParser.One_or_and_expressionContext ctx) {
        return (IFQLExpression)super.visitOne_or_and_expression(ctx);
    }

    @Override
    public IFQLExpression visitParenthesesExpression(FQLParser.ParenthesesExpressionContext ctx) {
        return (IFQLExpression)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public IFQLExpression visitNotExpression(FQLParser.NotExpressionContext ctx) {
        FQLUnaryExpr fqlUnaryExpr = new FQLUnaryExpr("not");
        fqlUnaryExpr.setExpr((IFQLExpression)this.visit((ParseTree)ctx.one_expression()));
        return fqlUnaryExpr;
    }

    @Override
    public IFQLExpression visitAndExpression(FQLParser.AndExpressionContext ctx) {
        Object expression2;
        ArrayList list = Lists.newArrayList();
        for (Object expression2 : ctx.one_expression()) {
            list.add(this.visit((ParseTree)expression2));
        }
        if (list.size() < 2) {
            return null;
        }
        FQLLogicalExpr expr = new FQLLogicalExpr("and");
        expression2 = expr;
        expr.setLeftExpr((IFQLExpression)list.get(0));
        for (int i = 1; i < list.size() - 1; ++i) {
            FQLLogicalExpr exprTemp = new FQLLogicalExpr("and");
            expr.setRightExpr(exprTemp);
            exprTemp.setLeftExpr((IFQLExpression)list.get(i));
            expr = exprTemp;
        }
        expr.setRightExpr((IFQLExpression)list.get(list.size() - 1));
        return expression2;
    }

    @Override
    public IFQLExpression visitOrExpression(FQLParser.OrExpressionContext ctx) {
        Object expression2;
        ArrayList list = Lists.newArrayList();
        for (Object expression2 : ctx.one_or_and_expression()) {
            list.add(this.visit((ParseTree)expression2));
        }
        if (list.size() < 2) {
            return null;
        }
        FQLLogicalExpr expr = new FQLLogicalExpr("or");
        expression2 = expr;
        expr.setLeftExpr((IFQLExpression)list.get(0));
        for (int i = 1; i < list.size() - 1; ++i) {
            FQLLogicalExpr exprTemp = new FQLLogicalExpr("or");
            expr.setRightExpr(exprTemp);
            exprTemp.setLeftExpr((IFQLExpression)list.get(i));
            expr = exprTemp;
        }
        expr.setRightExpr((IFQLExpression)list.get(list.size() - 1));
        return expression2;
    }

    @Override
    public IFQLExpression visitSimpleExpression(FQLParser.SimpleExpressionContext ctx) {
        return (IFQLExpression)super.visitSimpleExpression(ctx);
    }

    @Override
    public IFQLExpression visitSingleCompareExpression(FQLParser.SingleCompareExpressionContext ctx) {
        String key = ctx.ID().getText();
        FQLKeyWord.Operator op = FQLKeyWord.getOp(ctx.comparison_operator().getText());
        IFQLExpression value = (IFQLExpression)this.visit((ParseTree)ctx.value_atom());
        FQLMathExpr fqlMathExpr = new FQLMathExpr(key, op, value);
        return fqlMathExpr;
    }

    @Override
    public IFQLExpression visitListCompareExpression(FQLParser.ListCompareExpressionContext ctx) {
        FQLInExpr fqlInExpr = new FQLInExpr();
        String key = ctx.ID().getText();
        IFQLExpression value = (IFQLExpression)this.visit((ParseTree)ctx.list_literal());
        fqlInExpr.setField(key);
        fqlInExpr.setValues(value);
        return fqlInExpr;
    }

    @Override
    public IFQLExpression visitNullCompareExpression(FQLParser.NullCompareExpressionContext ctx) {
        FQLIsNullExpr fqlIsNullExpr = new FQLIsNullExpr();
        String field = ctx.ID().getText();
        fqlIsNullExpr.setField(field);
        if (ctx.NOT() != null) {
            fqlIsNullExpr.setIsNull(false);
        } else {
            fqlIsNullExpr.setIsNull(true);
        }
        return fqlIsNullExpr;
    }

    @Override
    public IFQLExpression visitExistExpression(FQLParser.ExistExpressionContext ctx) {
        String key = ctx.ID().getText();
        FqlExistExpr fqlExistExpr = new FqlExistExpr(key);
        return fqlExistExpr;
    }

    @Override
    public IFQLExpression visitLikeExpression(FQLParser.LikeExpressionContext ctx) {
        String strPattern = ctx.string_literal().getText();
        String key = ctx.ID().getText();
        FQLLikeExpr fqlLikeExpr = new FQLLikeExpr(key, strPattern.substring(1, strPattern.length() - 1));
        return fqlLikeExpr;
    }

    @Override
    public IFQLExpression visitRlikeExpression(FQLParser.RlikeExpressionContext ctx) {
        String strPattern = ctx.string_literal().getText();
        FQLRLikeExpression fqlLikeExpr = new FQLRLikeExpression(ctx.ID().getText(), strPattern.substring(1, strPattern.length() - 1));
        return fqlLikeExpr;
    }

    @Override
    public IFQLExpression visitValue_atom(FQLParser.Value_atomContext ctx) {
        if (ctx.decimal_literal() != null) {
            return (IFQLExpression)this.visit((ParseTree)ctx.decimal_literal());
        }
        if (ctx.string_literal() != null) {
            return (IFQLExpression)this.visit((ParseTree)ctx.string_literal());
        }
        if (ctx.bool_constant() != null) {
            return (IFQLExpression)this.visit((ParseTree)ctx.bool_constant());
        }
        return (IFQLExpression)this.visit((ParseTree)ctx.date_literal());
    }

    @Override
    public IFQLExpression visitString_literal(FQLParser.String_literalContext ctx) {
        String text = ctx.getText();
        text = text.substring(1, text.length() - 1);
        return new FQLStringValue(text);
    }

    @Override
    public IFQLExpression visitDoubleLiteral(FQLParser.DoubleLiteralContext ctx) {
        String text = ctx.getText();
        return new FQLDoubleValue(text);
    }

    @Override
    public IFQLExpression visitLongLiteral(FQLParser.LongLiteralContext ctx) {
        String text = ctx.getText();
        return new FQLLongValue(text);
    }

    @Override
    public IFQLExpression visitBool_constant(FQLParser.Bool_constantContext ctx) {
        if (ctx.TRUE() != null) {
            return new FQLBooleanValue(true);
        }
        return new FQLBooleanValue(false);
    }

    @Override
    public IFQLExpression visitDate_literal(FQLParser.Date_literalContext ctx) {
        if (ctx.S_UTC_TIME() != null || ctx.D_UTC_TIME() != null) {
            String utcTime = null;
            utcTime = ctx.S_UTC_TIME() != null ? ctx.S_UTC_TIME().getText() : ctx.D_UTC_TIME().getText();
            utcTime = utcTime.substring(1, 11) + " " + utcTime.substring(12, 20);
            Date date = FQLConvertVistor.parseDate(utcTime);
            return new FQLUTCTimeValue(date.getTime());
        }
        String localTimeStrQuoted = ctx.S_LOCAL_TIME() != null ? ctx.S_LOCAL_TIME().getText() : ctx.D_LOCAL_TIME().getText();
        FQLLocalTimeValue localTimeValue = new FQLLocalTimeValue(localTimeStrQuoted);
        String localTimeUnquoted = localTimeStrQuoted.substring(1, localTimeStrQuoted.length() - 1);
        Date date = FQLConvertVistor.parseDate(localTimeUnquoted);
        localTimeValue.setLocalDate(date);
        return localTimeValue;
    }

    @Override
    public IFQLExpression visitNull_constant(FQLParser.Null_constantContext ctx) {
        return (IFQLExpression)super.visitNull_constant(ctx);
    }

    @Override
    public IFQLExpression visitList_literal(FQLParser.List_literalContext ctx) {
        List<FQLParser.Decimal_literalContext> numList = ctx.decimal_literal();
        List<FQLParser.String_literalContext> stringList = ctx.string_literal();
        FQLListValue re = new FQLListValue();
        if (numList != null && numList.size() > 0) {
            for (FQLParser.Decimal_literalContext context : numList) {
                re.add((IFQLExpression)this.visit((ParseTree)context));
            }
        } else {
            for (FQLParser.String_literalContext context : stringList) {
                re.add((IFQLExpression)this.visit((ParseTree)context));
            }
        }
        return re;
    }

    private static Date parseDate(String timeStr) {
        Date date;
        SimpleDateFormat df = new SimpleDateFormat(DATEFORMATE);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            date = df.parse(timeStr);
        }
        catch (Exception e) {
            throw new RuntimeException("parse time format error" + timeStr);
        }
        return date;
    }

    public static void main(String[] args) {
        try {
            IFQLExpression expr = FQLConvertVistor.parse("a = 1 && b in (2,3,4) and exists (c)");
            System.out.println(expr.toString());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private static class ErrorReportParser
    extends FQLParser {
        public ErrorReportParser(TokenStream input) {
            super(input);
            this.removeErrorListeners();
            this.addErrorListener((ANTLRErrorListener)new FQLErrorListener());
        }
    }
}

