/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.constant;

import com.envisioniot.enos.api.framework.expr.exception.FQLGrammarException;
import java.io.Serializable;

public class FQLKeyWord
implements Serializable {
    private static final long serialVersionUID = -8731502442826654086L;

    public static Operator getOp(String op) {
        String smallOp;
        switch (smallOp = op.toLowerCase()) {
            case "=": {
                return Operator.EQ;
            }
            case ">": {
                return Operator.GT;
            }
            case "<": {
                return Operator.LT;
            }
            case ">=": {
                return Operator.GTE;
            }
            case "<=": {
                return Operator.LTE;
            }
            case "!=": {
                return Operator.NEQ;
            }
            case "in": {
                return Operator.IN;
            }
            case "is null": {
                return Operator.ISNULL;
            }
            case "is not null": {
                return Operator.ISNOTNULL;
            }
            case "like": {
                return Operator.LIKE;
            }
            case "rlike": {
                return Operator.RLIKE;
            }
        }
        throw new FQLGrammarException("illegal operation: " + op);
    }

    public static ValueType getValueType(String valueType) {
        String type;
        switch (type = valueType.toLowerCase()) {
            case "string": {
                return ValueType.STRING;
            }
            case "long": {
                return ValueType.LONG;
            }
            case "number": {
                return ValueType.NUMBER;
            }
            case "date": {
                return ValueType.DATE;
            }
            case "any": {
                return ValueType.ANY;
            }
        }
        throw new FQLGrammarException("illegal value type: " + valueType);
    }

    public static enum ValueType {
        STRING("string"),
        LONG("long"),
        DOUBLE("double"),
        NUMBER("number"),
        DATE("date"),
        BOOLEAN("boolean"),
        ANY("any");

        private final String literal;

        private ValueType(String literal) {
            this.literal = literal;
        }

        public String toString() {
            return this.literal;
        }
    }

    public static enum BinaryOperator {
        AND,
        OR;

    }

    public static enum Operator {
        EQ("="),
        GT(">"),
        LT("<"),
        GTE(">="),
        LTE("<="),
        NEQ("!="),
        IN("in"),
        ISNULL("is null"),
        ISNOTNULL("is not null"),
        LIKE("like"),
        RLIKE("rlike"),
        EXISTS("exists");

        private final String literal;

        private Operator(String literal) {
            this.literal = literal;
        }

        public String getLiteral() {
            return this.literal;
        }

        public String toString() {
            return this.literal;
        }
    }
}

