/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.expressionV2;

import com.envisioniot.enos.api.framework.expr.constant.FQLKeyWord;
import com.envisioniot.enos.api.framework.expr.exception.FQLGrammarException;
import com.envisioniot.enos.api.framework.expr.expressionV2.IExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.ILogicalExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.IValueExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.antlrgen.FQLBaseVisitor;
import com.envisioniot.enos.api.framework.expr.expressionV2.antlrgen.FQLLexer;
import com.envisioniot.enos.api.framework.expr.expressionV2.antlrgen.FQLParser;
import com.envisioniot.enos.api.framework.expr.expressionV2.listener.FQLErrorListener;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.AndExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.ExistExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.FunctionExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.InExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.IsNullExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.LikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.MathExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.NotExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.OrExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.RLikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.util.FQLConvertUtil;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.BasePrimitiveValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.BooleanValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.DoubleValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.ListValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.LocalTimeValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.LongValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.StringValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.UTCTimeValueExpr;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionConvertVisitor
extends FQLBaseVisitor<IExpression> {
    private static final Logger log = LoggerFactory.getLogger(ExpressionConvertVisitor.class);
    private static final String DATEFORMATE = "yyyy-MM-dd HH:mm:ss";
    private static final String REVERSE_QUOTE = "`";
    private static final String SPLIT_DOTTED = "\\.";
    private static final String DOTTED = ".";

    public static IExpression parse(String fql) {
        FQLLexer lexer;
        ByteArrayInputStream is = new ByteArrayInputStream(fql.getBytes());
        try {
            lexer = new FQLLexer(CharStreams.fromStream((InputStream)is));
        }
        catch (Exception e) {
            throw new FQLGrammarException(e.getMessage());
        }
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new FQLErrorListener());
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ErrorReportParser parser = new ErrorReportParser((TokenStream)tokens);
        FQLParser.FqlContext tree = parser.fql();
        ExpressionConvertVisitor visitor = new ExpressionConvertVisitor();
        return (IExpression)visitor.visit((ParseTree)tree);
    }

    @Override
    public IExpression visitFql(FQLParser.FqlContext ctx) {
        return (IExpression)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public IExpression visitOneExpression(FQLParser.OneExpressionContext ctx) {
        return (IExpression)super.visitOneExpression(ctx);
    }

    @Override
    public IExpression visitOrExpression(FQLParser.OrExpressionContext ctx) {
        List<ILogicalExpression> expressionList = ctx.one_or_and_expression().stream().map(context -> {
            IExpression OneExpression = (IExpression)this.visit((ParseTree)context);
            if (OneExpression instanceof ILogicalExpression) {
                return (ILogicalExpression)OneExpression;
            }
            log.error("expression parameter error, FQLParser.OrExpressionContext: {}", (Object)ctx);
            throw new FQLGrammarException("expression parameter error, FQLParser.OrExpressionContext: [" + (Object)((Object)ctx) + "]");
        }).collect(Collectors.toList());
        return new OrExpression(expressionList);
    }

    @Override
    public IExpression visitMoreAndExpression(FQLParser.MoreAndExpressionContext ctx) {
        return (IExpression)super.visitMoreAndExpression(ctx);
    }

    @Override
    public IExpression visitSimpleExpression(FQLParser.SimpleExpressionContext ctx) {
        return (IExpression)super.visitSimpleExpression(ctx);
    }

    @Override
    public IExpression visitParenthesesExpression(FQLParser.ParenthesesExpressionContext ctx) {
        return (IExpression)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public IExpression visitNotExpression(FQLParser.NotExpressionContext ctx) {
        IExpression oneExpression = (IExpression)this.visit((ParseTree)ctx.one_expression());
        if (oneExpression instanceof ILogicalExpression) {
            return new NotExpression((ILogicalExpression)oneExpression);
        }
        log.error("expression parameter error, FQLParser.NotExpressionContext: {}", (Object)ctx);
        throw new FQLGrammarException("expression parameter error, FQLParser.NotExpressionContext: [" + (Object)((Object)ctx) + "]");
    }

    @Override
    public IExpression visitOne_or_and_expression(FQLParser.One_or_and_expressionContext ctx) {
        return (IExpression)super.visitOne_or_and_expression(ctx);
    }

    @Override
    public IExpression visitAndExpression(FQLParser.AndExpressionContext ctx) {
        List<ILogicalExpression> expressionList = ctx.one_expression().stream().map(context -> {
            IExpression OneExpression = (IExpression)this.visit((ParseTree)context);
            if (OneExpression instanceof ILogicalExpression) {
                return (ILogicalExpression)OneExpression;
            }
            log.error("expression parameter error, FQLParser.AndExpressionContext: {}", (Object)ctx);
            throw new FQLGrammarException("expression parameter error, FQLParser.AndExpressionContext: [" + (Object)((Object)ctx) + "]");
        }).collect(Collectors.toList());
        return new AndExpression(expressionList);
    }

    @Override
    public IExpression visitSingleCompareExpression(FQLParser.SingleCompareExpressionContext ctx) {
        IExpression value;
        List<String> field = this.visit_Field_List(ctx.FULLCOLUMNNAME());
        FQLKeyWord.Operator op = FQLKeyWord.getOp(ctx.comparison_operator().getText());
        IExpression iExpression = value = Objects.nonNull((Object)ctx.value_atom()) ? (IExpression)this.visit((ParseTree)ctx.value_atom()) : (IExpression)this.visit((ParseTree)ctx.function_expr());
        if (value instanceof IValueExpression) {
            return new MathExpression(field, op, (IValueExpression)value);
        }
        log.error("expression parameter error, FQLParser.SingleCompareExpressionContext: {}", (Object)ctx);
        throw new FQLGrammarException("expression parameter error, FQLParser.SingleCompareExpressionContext: [" + (Object)((Object)ctx) + "]");
    }

    @Override
    public IExpression visitListCompareExpression(FQLParser.ListCompareExpressionContext ctx) {
        IExpression valueList;
        IExpression iExpression = valueList = Objects.nonNull((Object)ctx.list_literal()) ? (IExpression)this.visit((ParseTree)ctx.list_literal()) : (IExpression)this.visit((ParseTree)ctx.function_expr());
        if (valueList instanceof IValueExpression) {
            return new InExpression(this.visit_Field_List(ctx.FULLCOLUMNNAME()), (IValueExpression)valueList);
        }
        log.error("expression parameter error, FQLParser.ListCompareExpressionContext: {}", (Object)ctx);
        throw new FQLGrammarException("expression parameter error, FQLParser.ListCompareExpressionContext: [" + (Object)((Object)ctx) + "]");
    }

    @Override
    public IExpression visitNullCompareExpression(FQLParser.NullCompareExpressionContext ctx) {
        return new IsNullExpression(this.visit_Field_List(ctx.FULLCOLUMNNAME()), Objects.isNull(ctx.NOT()));
    }

    @Override
    public IExpression visitExistExpression(FQLParser.ExistExpressionContext ctx) {
        return new ExistExpression(this.visit_Field_List(ctx.FULLCOLUMNNAME()));
    }

    @Override
    public IExpression visitLikeExpression(FQLParser.LikeExpressionContext ctx) {
        IExpression valueExpr;
        IExpression iExpression = valueExpr = Objects.nonNull((Object)ctx.string_literal()) ? (IExpression)this.visit((ParseTree)ctx.string_literal()) : (IExpression)this.visit((ParseTree)ctx.function_expr());
        if (valueExpr instanceof IValueExpression) {
            return new LikeExpression(this.visit_Field_List(ctx.FULLCOLUMNNAME()), (IValueExpression)valueExpr);
        }
        log.error("expression parameter error, FQLParser.LikeExpressionContext: {}", (Object)ctx);
        throw new FQLGrammarException("expression parameter error, FQLParser.LikeExpressionContext: [" + (Object)((Object)ctx) + "]");
    }

    @Override
    public IExpression visitRlikeExpression(FQLParser.RlikeExpressionContext ctx) {
        IExpression valueExpr;
        IExpression iExpression = valueExpr = Objects.nonNull((Object)ctx.string_literal()) ? (IExpression)this.visit((ParseTree)ctx.string_literal()) : (IExpression)this.visit((ParseTree)ctx.function_expr());
        if (valueExpr instanceof IValueExpression) {
            return new RLikeExpression(this.visit_Field_List(ctx.FULLCOLUMNNAME()), (IValueExpression)valueExpr);
        }
        log.error("expression parameter error, FQLParser.RlikeExpressionContext: {}", (Object)ctx);
        throw new FQLGrammarException("expression parameter error, FQLParser.RlikeExpressionContext: [" + (Object)((Object)ctx) + "]");
    }

    @Override
    public IExpression visitFunction(FQLParser.FunctionContext ctx) {
        FunctionExpression expression = new FunctionExpression();
        expression.setName(String.join((CharSequence)DOTTED, this.visit_Field_List(ctx.FULLCOLUMNNAME())));
        ArrayList list = Lists.newArrayList();
        if (ctx.function_args() != null) {
            ctx.function_args().forEach(context -> {
                if (context instanceof FQLParser.NullConstantContext) {
                    list.add(null);
                } else {
                    IExpression arg = (IExpression)this.visit((ParseTree)context);
                    if (arg instanceof IValueExpression) {
                        list.add((IValueExpression)arg);
                    } else {
                        log.error("expression parameter error, FQLParser.FunctionContext: {}", (Object)ctx);
                        throw new FQLGrammarException("expression parameter error, FQLParser.FunctionContext: [" + (Object)((Object)ctx) + "]");
                    }
                }
            });
        }
        expression.setArgs(list);
        return expression;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<String> visit_Field_List(TerminalNode ctx) {
        String field = ctx.getText();
        if (!field.contains(REVERSE_QUOTE)) {
            return Arrays.asList(field.split(SPLIT_DOTTED));
        }
        ArrayList fieldList = Lists.newArrayList();
        String[] fieldArr = field.split(SPLIT_DOTTED);
        AtomicReference<Integer> index = new AtomicReference<Integer>(0);
        while (index.get() < fieldArr.length) {
            if (fieldArr[index.get()].contains(REVERSE_QUOTE)) {
                int appearNum = this.appearNum(fieldArr[index.get()], REVERSE_QUOTE);
                if (appearNum != 1 && appearNum != 2) {
                    log.error("expression parameter error, TerminalNode: {}", (Object)ctx);
                    throw new FQLGrammarException("expression parameter error, TerminalNode: [" + ctx + "]");
                }
                fieldList.add(this.getSubField(fieldArr, index, appearNum, field));
            } else {
                fieldList.add(fieldArr[index.get()]);
            }
            index.set(index.get() + 1);
        }
        return fieldList;
    }

    @Override
    public IExpression visitAtomArgs(FQLParser.AtomArgsContext ctx) {
        return (IExpression)this.visit((ParseTree)ctx.value_atom());
    }

    @Override
    public IExpression visitListArgs(FQLParser.ListArgsContext ctx) {
        return (IExpression)this.visit((ParseTree)ctx.list_literal());
    }

    @Override
    public IExpression visitValue_atom(FQLParser.Value_atomContext ctx) {
        if (Objects.nonNull((Object)ctx.string_literal())) {
            return (IExpression)this.visit((ParseTree)ctx.string_literal());
        }
        if (Objects.nonNull((Object)ctx.long_literal())) {
            return (IExpression)this.visit((ParseTree)ctx.long_literal());
        }
        if (Objects.nonNull((Object)ctx.double_literal())) {
            return (IExpression)this.visit((ParseTree)ctx.double_literal());
        }
        if (Objects.nonNull((Object)ctx.date_literal())) {
            return (IExpression)this.visit((ParseTree)ctx.date_literal());
        }
        return (IExpression)this.visit((ParseTree)ctx.bool_constant());
    }

    @Override
    public IExpression visitBool_constant(FQLParser.Bool_constantContext ctx) {
        return ctx.TRUE() != null ? new BooleanValueExpr(true) : new BooleanValueExpr(false);
    }

    @Override
    public IExpression visitLong_literal(FQLParser.Long_literalContext ctx) {
        return new LongValueExpr(Long.parseLong(ctx.LONG().getText()));
    }

    @Override
    public IExpression visitDouble_literal(FQLParser.Double_literalContext ctx) {
        return new DoubleValueExpr(Double.parseDouble(ctx.DOUBLE().getText()));
    }

    @Override
    public IExpression visitString_literal(FQLParser.String_literalContext ctx) {
        String text = ctx.getText();
        return new StringValueExpr(FQLConvertUtil.unescapeFQL(text.substring(1, text.length() - 1)));
    }

    @Override
    public IExpression visitDate_literal(FQLParser.Date_literalContext ctx) {
        if (ctx.S_UTC_TIME() != null || ctx.D_UTC_TIME() != null) {
            String utcTime = Objects.nonNull(ctx.S_UTC_TIME()) ? ctx.S_UTC_TIME().getText() : ctx.D_UTC_TIME().getText();
            Date date = ExpressionConvertVisitor.parseDate(utcTime.substring(1, 11) + " " + utcTime.substring(12, 20));
            return new UTCTimeValueExpr(utcTime.substring(1, utcTime.length() - 1), date.getTime());
        }
        String localTimeStrQuoted = ctx.S_LOCAL_TIME() != null ? ctx.S_LOCAL_TIME().getText() : ctx.D_LOCAL_TIME().getText();
        String localTimeUnquoted = localTimeStrQuoted.substring(1, localTimeStrQuoted.length() - 1);
        Date date = ExpressionConvertVisitor.parseDate(localTimeUnquoted);
        return new LocalTimeValueExpr(localTimeUnquoted, date);
    }

    @Override
    public IExpression visitList_literal(FQLParser.List_literalContext ctx) {
        List<FQLParser.Long_literalContext> longList = ctx.long_literal();
        List<FQLParser.Double_literalContext> doubleList = ctx.double_literal();
        List<FQLParser.String_literalContext> stringList = ctx.string_literal();
        List<FQLParser.Bool_constantContext> boolList = ctx.bool_constant();
        if (CollectionUtils.isNotEmpty(longList)) {
            return this.getPrimitiveList(longList);
        }
        if (CollectionUtils.isNotEmpty(doubleList)) {
            return this.getPrimitiveList(doubleList);
        }
        if (CollectionUtils.isNotEmpty(stringList)) {
            return this.getPrimitiveList(stringList);
        }
        return this.getPrimitiveList(boolList);
    }

    private <T extends ParserRuleContext, C extends BasePrimitiveValueExpr<?>> IExpression getPrimitiveList(List<T> primitiveList) {
        ListValueExpr expression = new ListValueExpr();
        primitiveList.forEach(context -> expression.add((BasePrimitiveValueExpr)this.visit((ParseTree)context)));
        return expression;
    }

    private static Date parseDate(String timeStr) {
        Date date;
        SimpleDateFormat df = new SimpleDateFormat(DATEFORMATE);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            date = df.parse(timeStr);
        }
        catch (Exception e) {
            log.error("parse time format error: {}", (Object)timeStr);
            throw new RuntimeException("parse time format error" + timeStr);
        }
        return date;
    }

    private String getSubField(String[] fieldArr, AtomicReference<Integer> index, int appearNum, String field) {
        if (appearNum == 2) {
            return fieldArr[index.get()].substring(1, fieldArr[index.get()].length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(fieldArr[index.get()] + DOTTED);
            index.set(index.get() + 1);
            if (index.get() < fieldArr.length) continue;
            log.error("expression field format error, field: {}", (Object)field);
            throw new FQLGrammarException("expression field format error, field: " + field);
        } while (!fieldArr[index.get()].contains(REVERSE_QUOTE));
        sb.append(fieldArr[index.get()] + DOTTED);
        return sb.substring(1, sb.length() - 2);
    }

    private int appearNum(String srcText, String findText) {
        int count = 0;
        int index = 0;
        while ((index = srcText.indexOf(findText, index)) != -1) {
            ++count;
            index += findText.length();
        }
        return count;
    }

    public static void main(String[] args) {
        String fi = "aadfd.`........\u5728...b2\u5728e3.......cwqe121............`.`sagudkqwu`.`.......`.`12w\u5728..`.dajsdka\u6c99\u53d1asd.`....da\u5168\u662f`";
        MathExpression expression = (MathExpression)FQLConvertUtil.fromFQLString("aadfd.`........\u5728...b2\u5728e3.......cwqe121............`.`sagudkqwu`.`.......`.`12w\u5728..`.dajsdka\u6c99\u53d1asd.`....da\u5168\u662f` = 1");
        System.out.println(expression);
        List<String> field = expression.getField();
    }

    private static class ErrorReportParser
    extends FQLParser {
        public ErrorReportParser(TokenStream input) {
            super(input);
            this.removeErrorListeners();
            this.addErrorListener((ANTLRErrorListener)new FQLErrorListener());
        }
    }
}

